<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EduOrganizationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Выбранные детские сады
 * @subpackage Structs
 */
class EduOrganizationsType extends AbstractStructBase
{
    /**
     * The EduOrganization
     * Meta information extracted from the WSDL
     * - maxOccurs: 50
     * @var \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType[]
     */
    public $EduOrganization;
    /**
     * The AllowOfferOther
     * @var bool
     */
    public $AllowOfferOther;
    /**
     * Constructor method for EduOrganizationsType
     * @uses EduOrganizationsType::setEduOrganization()
     * @uses EduOrganizationsType::setAllowOfferOther()
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType[] $eduOrganization
     * @param bool $allowOfferOther
     */
    public function __construct(array $eduOrganization = array(), $allowOfferOther = null)
    {
        $this
            ->setEduOrganization($eduOrganization)
            ->setAllowOfferOther($allowOfferOther);
    }
    /**
     * Get EduOrganization value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType[]|null
     */
    public function getEduOrganization()
    {
        return $this->EduOrganization;
    }
    /**
     * This method is responsible for validating the values passed to the setEduOrganization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEduOrganization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEduOrganizationForArrayConstraintsFromSetEduOrganization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eduOrganizationsTypeEduOrganizationItem) {
            // validation for constraint: itemType
            if (!$eduOrganizationsTypeEduOrganizationItem instanceof \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType) {
                $invalidValues[] = is_object($eduOrganizationsTypeEduOrganizationItem) ? get_class($eduOrganizationsTypeEduOrganizationItem) : sprintf('%s(%s)', gettype($eduOrganizationsTypeEduOrganizationItem), var_export($eduOrganizationsTypeEduOrganizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EduOrganization property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EduOrganization value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType[] $eduOrganization
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType
     */
    public function setEduOrganization(array $eduOrganization = array())
    {
        // validation for constraint: array
        if ('' !== ($eduOrganizationArrayErrorMessage = self::validateEduOrganizationForArrayConstraintsFromSetEduOrganization($eduOrganization))) {
            throw new \InvalidArgumentException($eduOrganizationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($eduOrganization) && count($eduOrganization) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($eduOrganization)), __LINE__);
        }
        $this->EduOrganization = $eduOrganization;
        return $this;
    }
    /**
     * Add item to EduOrganization value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType $item
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType
     */
    public function addToEduOrganization(\Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType) {
            throw new \InvalidArgumentException(sprintf('The EduOrganization property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->EduOrganization) && count($this->EduOrganization) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->EduOrganization)), __LINE__);
        }
        $this->EduOrganization[] = $item;
        return $this;
    }
    /**
     * Get AllowOfferOther value
     * @return bool|null
     */
    public function getAllowOfferOther()
    {
        return $this->AllowOfferOther;
    }
    /**
     * Set AllowOfferOther value
     * @param bool $allowOfferOther
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType
     */
    public function setAllowOfferOther($allowOfferOther = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOfferOther) && !is_bool($allowOfferOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOfferOther, true), gettype($allowOfferOther)), __LINE__);
        }
        $this->AllowOfferOther = $allowOfferOther;
        return $this;
    }
}
