<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChildBirthDocForeignType StructType
 * Meta information extracted from the WSDL
 * - documentation: Другой документ
 * @subpackage Structs
 */
class ChildBirthDocForeignType extends AbstractStructBase
{
    /**
     * The ChildBirthDocName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildBirthDocName;
    /**
     * The ChildBirthDocSeries
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $ChildBirthDocSeries;
    /**
     * The ChildBirthDocNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $ChildBirthDocNumber;
    /**
     * The ChildBirthDocIssueDate
     * @var string
     */
    public $ChildBirthDocIssueDate;
    /**
     * The ChildBirthDocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $ChildBirthDocIssued;
    /**
     * Constructor method for ChildBirthDocForeignType
     * @uses ChildBirthDocForeignType::setChildBirthDocName()
     * @uses ChildBirthDocForeignType::setChildBirthDocSeries()
     * @uses ChildBirthDocForeignType::setChildBirthDocNumber()
     * @uses ChildBirthDocForeignType::setChildBirthDocIssueDate()
     * @uses ChildBirthDocForeignType::setChildBirthDocIssued()
     * @param string $childBirthDocName
     * @param string $childBirthDocSeries
     * @param string $childBirthDocNumber
     * @param string $childBirthDocIssueDate
     * @param string $childBirthDocIssued
     */
    public function __construct($childBirthDocName = null, $childBirthDocSeries = null, $childBirthDocNumber = null, $childBirthDocIssueDate = null, $childBirthDocIssued = null)
    {
        $this
            ->setChildBirthDocName($childBirthDocName)
            ->setChildBirthDocSeries($childBirthDocSeries)
            ->setChildBirthDocNumber($childBirthDocNumber)
            ->setChildBirthDocIssueDate($childBirthDocIssueDate)
            ->setChildBirthDocIssued($childBirthDocIssued);
    }
    /**
     * Get ChildBirthDocName value
     * @return string|null
     */
    public function getChildBirthDocName()
    {
        return $this->ChildBirthDocName;
    }
    /**
     * Set ChildBirthDocName value
     * @param string $childBirthDocName
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType
     */
    public function setChildBirthDocName($childBirthDocName = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocName) && !is_string($childBirthDocName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocName, true), gettype($childBirthDocName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childBirthDocName) && mb_strlen($childBirthDocName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childBirthDocName)), __LINE__);
        }
        $this->ChildBirthDocName = $childBirthDocName;
        return $this;
    }
    /**
     * Get ChildBirthDocSeries value
     * @return string|null
     */
    public function getChildBirthDocSeries()
    {
        return $this->ChildBirthDocSeries;
    }
    /**
     * Set ChildBirthDocSeries value
     * @param string $childBirthDocSeries
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType
     */
    public function setChildBirthDocSeries($childBirthDocSeries = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocSeries) && !is_string($childBirthDocSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocSeries, true), gettype($childBirthDocSeries)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($childBirthDocSeries) && mb_strlen($childBirthDocSeries) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($childBirthDocSeries)), __LINE__);
        }
        $this->ChildBirthDocSeries = $childBirthDocSeries;
        return $this;
    }
    /**
     * Get ChildBirthDocNumber value
     * @return string|null
     */
    public function getChildBirthDocNumber()
    {
        return $this->ChildBirthDocNumber;
    }
    /**
     * Set ChildBirthDocNumber value
     * @param string $childBirthDocNumber
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType
     */
    public function setChildBirthDocNumber($childBirthDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocNumber) && !is_string($childBirthDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocNumber, true), gettype($childBirthDocNumber)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($childBirthDocNumber) && mb_strlen($childBirthDocNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($childBirthDocNumber)), __LINE__);
        }
        $this->ChildBirthDocNumber = $childBirthDocNumber;
        return $this;
    }
    /**
     * Get ChildBirthDocIssueDate value
     * @return string|null
     */
    public function getChildBirthDocIssueDate()
    {
        return $this->ChildBirthDocIssueDate;
    }
    /**
     * Set ChildBirthDocIssueDate value
     * @param string $childBirthDocIssueDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType
     */
    public function setChildBirthDocIssueDate($childBirthDocIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocIssueDate) && !is_string($childBirthDocIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocIssueDate, true), gettype($childBirthDocIssueDate)), __LINE__);
        }
        $this->ChildBirthDocIssueDate = $childBirthDocIssueDate;
        return $this;
    }
    /**
     * Get ChildBirthDocIssued value
     * @return string|null
     */
    public function getChildBirthDocIssued()
    {
        return $this->ChildBirthDocIssued;
    }
    /**
     * Set ChildBirthDocIssued value
     * @param string $childBirthDocIssued
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildBirthDocForeignType
     */
    public function setChildBirthDocIssued($childBirthDocIssued = null)
    {
        // validation for constraint: string
        if (!is_null($childBirthDocIssued) && !is_string($childBirthDocIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childBirthDocIssued, true), gettype($childBirthDocIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($childBirthDocIssued) && mb_strlen($childBirthDocIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($childBirthDocIssued)), __LINE__);
        }
        $this->ChildBirthDocIssued = $childBirthDocIssued;
        return $this;
    }
}
