<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Подача заявления для направления в дошкольную организацию.
 * @subpackage Structs
 */
class ApplicationType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The ServicesType
     * Meta information extracted from the WSDL
     * - base: xsd:normalizedString
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ServicesType;
    /**
     * The FilingDate
     * Meta information extracted from the WSDL
     * - documentation: Дата и время подачи. Передаётся только при первичной подаче заявления
     * - minOccurs: 0
     * @var string
     */
    public $FilingDate;
    /**
     * The PersonInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType
     */
    public $PersonInfo;
    /**
     * The PersonIdentityDocInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType
     */
    public $PersonIdentityDocInfo;
    /**
     * The ChildInfo
     * @var \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType
     */
    public $ChildInfo;
    /**
     * The Address
     * @var \Webservice\Service\Dto\SmevSoap\StructType\AddressType
     */
    public $Address;
    /**
     * The EntryParams
     * @var \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType
     */
    public $EntryParams;
    /**
     * The AdaptationProgram
     * @var \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType
     */
    public $AdaptationProgram;
    /**
     * The MedicalReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType
     */
    public $MedicalReport;
    /**
     * The EduOrganizations
     * @var \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType
     */
    public $EduOrganizations;
    /**
     * The BrotherSisterInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType[]
     */
    public $BrotherSisterInfo;
    /**
     * The BenefitInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType
     */
    public $BenefitInfo;
    /**
     * Constructor method for ApplicationType
     * @uses ApplicationType::setOrderId()
     * @uses ApplicationType::setServicesType()
     * @uses ApplicationType::setFilingDate()
     * @uses ApplicationType::setPersonInfo()
     * @uses ApplicationType::setPersonIdentityDocInfo()
     * @uses ApplicationType::setChildInfo()
     * @uses ApplicationType::setAddress()
     * @uses ApplicationType::setEntryParams()
     * @uses ApplicationType::setAdaptationProgram()
     * @uses ApplicationType::setMedicalReport()
     * @uses ApplicationType::setEduOrganizations()
     * @uses ApplicationType::setBrotherSisterInfo()
     * @uses ApplicationType::setBenefitInfo()
     * @param int $orderId
     * @param string $servicesType
     * @param string $filingDate
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AddressType $address
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram
     * @param \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType $eduOrganizations
     * @param \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType[] $brotherSisterInfo
     * @param \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType $benefitInfo
     */
    public function __construct($orderId = null, $servicesType = null, $filingDate = null, \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo = null, \Webservice\Service\Dto\SmevSoap\StructType\AddressType $address = null, \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams = null, \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram = null, \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport = null, \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType $eduOrganizations = null, array $brotherSisterInfo = array(), \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType $benefitInfo = null)
    {
        $this
            ->setOrderId($orderId)
            ->setServicesType($servicesType)
            ->setFilingDate($filingDate)
            ->setPersonInfo($personInfo)
            ->setPersonIdentityDocInfo($personIdentityDocInfo)
            ->setChildInfo($childInfo)
            ->setAddress($address)
            ->setEntryParams($entryParams)
            ->setAdaptationProgram($adaptationProgram)
            ->setMedicalReport($medicalReport)
            ->setEduOrganizations($eduOrganizations)
            ->setBrotherSisterInfo($brotherSisterInfo)
            ->setBenefitInfo($benefitInfo);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get ServicesType value
     * @return string|null
     */
    public function getServicesType()
    {
        return $this->ServicesType;
    }
    /**
     * Set ServicesType value
     * @param string $servicesType
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setServicesType($servicesType = null)
    {
        // validation for constraint: string
        if (!is_null($servicesType) && !is_string($servicesType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicesType, true), gettype($servicesType)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($servicesType) && mb_strlen($servicesType) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($servicesType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($servicesType) && mb_strlen($servicesType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($servicesType)), __LINE__);
        }
        $this->ServicesType = $servicesType;
        return $this;
    }
    /**
     * Get FilingDate value
     * @return string|null
     */
    public function getFilingDate()
    {
        return $this->FilingDate;
    }
    /**
     * Set FilingDate value
     * @param string $filingDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setFilingDate($filingDate = null)
    {
        // validation for constraint: string
        if (!is_null($filingDate) && !is_string($filingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filingDate, true), gettype($filingDate)), __LINE__);
        }
        $this->FilingDate = $filingDate;
        return $this;
    }
    /**
     * Get PersonInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType|null
     */
    public function getPersonInfo()
    {
        return $this->PersonInfo;
    }
    /**
     * Set PersonInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setPersonInfo(\Webservice\Service\Dto\SmevSoap\StructType\PersonInfoType $personInfo = null)
    {
        $this->PersonInfo = $personInfo;
        return $this;
    }
    /**
     * Get PersonIdentityDocInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType|null
     */
    public function getPersonIdentityDocInfo()
    {
        return $this->PersonIdentityDocInfo;
    }
    /**
     * Set PersonIdentityDocInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setPersonIdentityDocInfo(\Webservice\Service\Dto\SmevSoap\StructType\PersonIdentityDocInfoType $personIdentityDocInfo = null)
    {
        $this->PersonIdentityDocInfo = $personIdentityDocInfo;
        return $this;
    }
    /**
     * Get ChildInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType|null
     */
    public function getChildInfo()
    {
        return $this->ChildInfo;
    }
    /**
     * Set ChildInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setChildInfo(\Webservice\Service\Dto\SmevSoap\StructType\ChildInfoType $childInfo = null)
    {
        $this->ChildInfo = $childInfo;
        return $this;
    }
    /**
     * Get Address value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AddressType $address
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setAddress(\Webservice\Service\Dto\SmevSoap\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EntryParams value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType|null
     */
    public function getEntryParams()
    {
        return $this->EntryParams;
    }
    /**
     * Set EntryParams value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setEntryParams(\Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType $entryParams = null)
    {
        $this->EntryParams = $entryParams;
        return $this;
    }
    /**
     * Get AdaptationProgram value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType|null
     */
    public function getAdaptationProgram()
    {
        return $this->AdaptationProgram;
    }
    /**
     * Set AdaptationProgram value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setAdaptationProgram(\Webservice\Service\Dto\SmevSoap\StructType\AdaptationProgramType $adaptationProgram = null)
    {
        $this->AdaptationProgram = $adaptationProgram;
        return $this;
    }
    /**
     * Get MedicalReport value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType|null
     */
    public function getMedicalReport()
    {
        return $this->MedicalReport;
    }
    /**
     * Set MedicalReport value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setMedicalReport(\Webservice\Service\Dto\SmevSoap\StructType\MedicalReportType $medicalReport = null)
    {
        $this->MedicalReport = $medicalReport;
        return $this;
    }
    /**
     * Get EduOrganizations value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType|null
     */
    public function getEduOrganizations()
    {
        return $this->EduOrganizations;
    }
    /**
     * Set EduOrganizations value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType $eduOrganizations
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setEduOrganizations(\Webservice\Service\Dto\SmevSoap\StructType\EduOrganizationsType $eduOrganizations = null)
    {
        $this->EduOrganizations = $eduOrganizations;
        return $this;
    }
    /**
     * Get BrotherSisterInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType[]|null
     */
    public function getBrotherSisterInfo()
    {
        return $this->BrotherSisterInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setBrotherSisterInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBrotherSisterInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBrotherSisterInfoForArrayConstraintsFromSetBrotherSisterInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationTypeBrotherSisterInfoItem) {
            // validation for constraint: itemType
            if (!$applicationTypeBrotherSisterInfoItem instanceof \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType) {
                $invalidValues[] = is_object($applicationTypeBrotherSisterInfoItem) ? get_class($applicationTypeBrotherSisterInfoItem) : sprintf('%s(%s)', gettype($applicationTypeBrotherSisterInfoItem), var_export($applicationTypeBrotherSisterInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BrotherSisterInfo property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BrotherSisterInfo value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType[] $brotherSisterInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setBrotherSisterInfo(array $brotherSisterInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($brotherSisterInfoArrayErrorMessage = self::validateBrotherSisterInfoForArrayConstraintsFromSetBrotherSisterInfo($brotherSisterInfo))) {
            throw new \InvalidArgumentException($brotherSisterInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($brotherSisterInfo) && count($brotherSisterInfo) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($brotherSisterInfo)), __LINE__);
        }
        $this->BrotherSisterInfo = $brotherSisterInfo;
        return $this;
    }
    /**
     * Add item to BrotherSisterInfo value
     * @throws \InvalidArgumentException
     * @param \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType $item
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function addToBrotherSisterInfo(\Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType) {
            throw new \InvalidArgumentException(sprintf('The BrotherSisterInfo property can only contain items of type \Webservice\Service\Dto\SmevSoap\StructType\BrotherSisterInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->BrotherSisterInfo) && count($this->BrotherSisterInfo) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->BrotherSisterInfo)), __LINE__);
        }
        $this->BrotherSisterInfo[] = $item;
        return $this;
    }
    /**
     * Get BenefitInfo value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType|null
     */
    public function getBenefitInfo()
    {
        return $this->BenefitInfo;
    }
    /**
     * Set BenefitInfo value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType $benefitInfo
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationType
     */
    public function setBenefitInfo(\Webservice\Service\Dto\SmevSoap\StructType\BenefitInfoType $benefitInfo = null)
    {
        $this->BenefitInfo = $benefitInfo;
        return $this;
    }
}
