<?php

namespace Webservice\Service\Dto\SmevSoap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Form ServiceType
 * @subpackage Services
 */
class Form extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FormRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Webservice\Service\Dto\SmevSoap\StructType\FormRequest $parameters
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormResponse|bool
     */
    public function FormRequest(\Webservice\Service\Dto\SmevSoap\StructType\FormRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FormRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Webservice\Service\Dto\SmevSoap\StructType\FormResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
