<?php

namespace Webservice\Service\Dto\SmevSoap;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'DataElementType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\DataElementType',
            'AddressType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\AddressType',
            'AppliedDocumentType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\AppliedDocumentType',
            'DocInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\DocInfoType',
            'PersonInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\PersonInfoType',
            'OtherRepresentativeType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\OtherRepresentativeType',
            'PersonIdentityDocInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\PersonIdentityDocInfoType',
            'ChildInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ChildInfoType',
            'ChildBirthDocRFType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ChildBirthDocRFType',
            'ChildBirthDocForeignType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ChildBirthDocForeignType',
            'EntryParamsType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\EntryParamsType',
            'AdaptationProgramType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\AdaptationProgramType',
            'MedicalReportType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\MedicalReportType',
            'MedicalReportWithoutFilesType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\MedicalReportWithoutFilesType',
            'EduOrganizationType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\EduOrganizationType',
            'EduOrganizationsType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\EduOrganizationsType',
            'BrotherSisterInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\BrotherSisterInfoType',
            'BenefitInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\BenefitInfoType',
            'BenefitInfoWithoutFilesType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\BenefitInfoWithoutFilesType',
            'ApplicationType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ApplicationType',
            'ApplicationOrderInfoRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ApplicationOrderInfoRequestType',
            'Person2InfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\Person2InfoType',
            'ApplicationAdmissionRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ApplicationAdmissionRequestType',
            'GetApplicationQueueRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationQueueRequestType',
            'GetApplicationQueueReasonRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationQueueReasonRequestType',
            'GetApplicationRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationRequestType',
            'GetApplicationAdmissionRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationAdmissionRequestType',
            'ApplicationRejectionRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ApplicationRejectionRequestType',
            'cancelRequestType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\CancelRequestType',
            'orderIdType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\OrderIdType',
            'statusCodeType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\StatusCodeType',
            'changeOrderInfoType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ChangeOrderInfoType',
            'ApplicationQueueResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\ApplicationQueueResponseType',
            'GetApplicationQueueReasonResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationQueueReasonResponseType',
            'GetApplicationResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationResponseType',
            'GetApplicationAdmissionResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\GetApplicationAdmissionResponseType',
            'cancelResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\CancelResponseType',
            'FormDataType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\FormDataType',
            'FormDataResponseType' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\FormDataResponseType',
            'FormRequest' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\FormRequest',
            'FormResponse' => '\\Webservice\\Service\\Dto\\SmevSoap\\StructType\\FormResponse',
        );
    }
}
