<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for statusCodeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Статус заявления
 * @subpackage Structs
 */
class StatusCodeType extends AbstractStructBase
{
    /**
     * The orgCode
     * Meta information extracted from the WSDL
     * - documentation: Код статуса в ведомстве
     * - base: xsd:string
     * - choice: orgCode | techCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * @var string
     */
    public $orgCode;
    /**
     * The techCode
     * Meta information extracted from the WSDL
     * - documentation: Код статуса на ЕПГУ
     * - choice: orgCode | techCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $techCode;
    /**
     * Constructor method for statusCodeType
     * @uses StatusCodeType::setOrgCode()
     * @uses StatusCodeType::setTechCode()
     * @param string $orgCode
     * @param string $techCode
     */
    public function __construct($orgCode = null, $techCode = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setTechCode($techCode);
    }
    /**
     * Get orgCode value
     * @return string|null
     */
    public function getOrgCode()
    {
        return isset($this->orgCode) ? $this->orgCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrgCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrgCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrgCodeForChoiceConstraintsFromSetOrgCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'techCode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property orgCode can\'t be set as the property %s is already set. Only one property must be set among these properties: orgCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set orgCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $orgCode
     * @return \Webservice\Service\Dto\SmevSoap\StructType\StatusCodeType
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: string
        if (!is_null($orgCode) && !is_string($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgCode, true), gettype($orgCode)), __LINE__);
        }
        // validation for constraint: choice(orgCode, techCode)
        if ('' !== ($orgCodeChoiceErrorMessage = self::validateOrgCodeForChoiceConstraintsFromSetOrgCode($orgCode))) {
            throw new \InvalidArgumentException($orgCodeChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($orgCode) && mb_strlen($orgCode) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($orgCode)), __LINE__);
        }
        if (is_null($orgCode) || (is_array($orgCode) && empty($orgCode))) {
            unset($this->orgCode);
        } else {
            $this->orgCode = $orgCode;
        }
        return $this;
    }
    /**
     * Get techCode value
     * @return string|null
     */
    public function getTechCode()
    {
        return isset($this->techCode) ? $this->techCode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTechCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTechCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTechCodeForChoiceConstraintsFromSetTechCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'orgCode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property techCode can\'t be set as the property %s is already set. Only one property must be set among these properties: techCode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set techCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $techCode
     * @return \Webservice\Service\Dto\SmevSoap\StructType\StatusCodeType
     */
    public function setTechCode($techCode = null)
    {
        // validation for constraint: string
        if (!is_null($techCode) && !is_string($techCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($techCode, true), gettype($techCode)), __LINE__);
        }
        // validation for constraint: choice(orgCode, techCode)
        if ('' !== ($techCodeChoiceErrorMessage = self::validateTechCodeForChoiceConstraintsFromSetTechCode($techCode))) {
            throw new \InvalidArgumentException($techCodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($techCode) || (is_array($techCode) && empty($techCode))) {
            unset($this->techCode);
        } else {
            $this->techCode = $techCode;
        }
        return $this;
    }
}
