<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person2InfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Сведения о 2-м родителе
 * @subpackage Structs
 */
class Person2InfoType extends AbstractStructBase
{
    /**
     * The Person2Surname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $Person2Surname;
    /**
     * The Person2Name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $Person2Name;
    /**
     * The Person2MiddleName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $Person2MiddleName;
    /**
     * The Person2Phone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - minOccurs: 0
     * @var string
     */
    public $Person2Phone;
    /**
     * The Person2Email
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $Person2Email;
    /**
     * Constructor method for Person2InfoType
     * @uses Person2InfoType::setPerson2Surname()
     * @uses Person2InfoType::setPerson2Name()
     * @uses Person2InfoType::setPerson2MiddleName()
     * @uses Person2InfoType::setPerson2Phone()
     * @uses Person2InfoType::setPerson2Email()
     * @param string $person2Surname
     * @param string $person2Name
     * @param string $person2MiddleName
     * @param string $person2Phone
     * @param string $person2Email
     */
    public function __construct($person2Surname = null, $person2Name = null, $person2MiddleName = null, $person2Phone = null, $person2Email = null)
    {
        $this
            ->setPerson2Surname($person2Surname)
            ->setPerson2Name($person2Name)
            ->setPerson2MiddleName($person2MiddleName)
            ->setPerson2Phone($person2Phone)
            ->setPerson2Email($person2Email);
    }
    /**
     * Get Person2Surname value
     * @return string|null
     */
    public function getPerson2Surname()
    {
        return $this->Person2Surname;
    }
    /**
     * Set Person2Surname value
     * @param string $person2Surname
     * @return \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType
     */
    public function setPerson2Surname($person2Surname = null)
    {
        // validation for constraint: string
        if (!is_null($person2Surname) && !is_string($person2Surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person2Surname, true), gettype($person2Surname)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($person2Surname) && mb_strlen($person2Surname) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($person2Surname)), __LINE__);
        }
        $this->Person2Surname = $person2Surname;
        return $this;
    }
    /**
     * Get Person2Name value
     * @return string|null
     */
    public function getPerson2Name()
    {
        return $this->Person2Name;
    }
    /**
     * Set Person2Name value
     * @param string $person2Name
     * @return \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType
     */
    public function setPerson2Name($person2Name = null)
    {
        // validation for constraint: string
        if (!is_null($person2Name) && !is_string($person2Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person2Name, true), gettype($person2Name)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($person2Name) && mb_strlen($person2Name) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($person2Name)), __LINE__);
        }
        $this->Person2Name = $person2Name;
        return $this;
    }
    /**
     * Get Person2MiddleName value
     * @return string|null
     */
    public function getPerson2MiddleName()
    {
        return $this->Person2MiddleName;
    }
    /**
     * Set Person2MiddleName value
     * @param string $person2MiddleName
     * @return \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType
     */
    public function setPerson2MiddleName($person2MiddleName = null)
    {
        // validation for constraint: string
        if (!is_null($person2MiddleName) && !is_string($person2MiddleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person2MiddleName, true), gettype($person2MiddleName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($person2MiddleName) && mb_strlen($person2MiddleName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($person2MiddleName)), __LINE__);
        }
        $this->Person2MiddleName = $person2MiddleName;
        return $this;
    }
    /**
     * Get Person2Phone value
     * @return string|null
     */
    public function getPerson2Phone()
    {
        return $this->Person2Phone;
    }
    /**
     * Set Person2Phone value
     * @param string $person2Phone
     * @return \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType
     */
    public function setPerson2Phone($person2Phone = null)
    {
        // validation for constraint: string
        if (!is_null($person2Phone) && !is_string($person2Phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person2Phone, true), gettype($person2Phone)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($person2Phone) && mb_strlen($person2Phone) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($person2Phone)), __LINE__);
        }
        $this->Person2Phone = $person2Phone;
        return $this;
    }
    /**
     * Get Person2Email value
     * @return string|null
     */
    public function getPerson2Email()
    {
        return $this->Person2Email;
    }
    /**
     * Set Person2Email value
     * @param string $person2Email
     * @return \Webservice\Service\Dto\SmevSoap\StructType\Person2InfoType
     */
    public function setPerson2Email($person2Email = null)
    {
        // validation for constraint: string
        if (!is_null($person2Email) && !is_string($person2Email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person2Email, true), gettype($person2Email)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($person2Email) && mb_strlen($person2Email) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($person2Email)), __LINE__);
        }
        $this->Person2Email = $person2Email;
        return $this;
    }
}
