<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntryParamsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Желаемые параметры зачисления
 * @subpackage Structs
 */
class EntryParamsType extends AbstractStructBase
{
    /**
     * The EntryDate
     * @var string
     */
    public $EntryDate;
    /**
     * The Language
     * @var \Webservice\Service\Dto\SmevSoap\StructType\DataElementType
     */
    public $Language;
    /**
     * The Schedule
     * @var \Webservice\Service\Dto\SmevSoap\StructType\DataElementType
     */
    public $Schedule;
    /**
     * The AgreementOnFullDayGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AgreementOnFullDayGroup;
    /**
     * Constructor method for EntryParamsType
     * @uses EntryParamsType::setEntryDate()
     * @uses EntryParamsType::setLanguage()
     * @uses EntryParamsType::setSchedule()
     * @uses EntryParamsType::setAgreementOnFullDayGroup()
     * @param string $entryDate
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $language
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $schedule
     * @param bool $agreementOnFullDayGroup
     */
    public function __construct($entryDate = null, \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $language = null, \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $schedule = null, $agreementOnFullDayGroup = null)
    {
        $this
            ->setEntryDate($entryDate)
            ->setLanguage($language)
            ->setSchedule($schedule)
            ->setAgreementOnFullDayGroup($agreementOnFullDayGroup);
    }
    /**
     * Get EntryDate value
     * @return string|null
     */
    public function getEntryDate()
    {
        return $this->EntryDate;
    }
    /**
     * Set EntryDate value
     * @param string $entryDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType
     */
    public function setEntryDate($entryDate = null)
    {
        // validation for constraint: string
        if (!is_null($entryDate) && !is_string($entryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryDate, true), gettype($entryDate)), __LINE__);
        }
        $this->EntryDate = $entryDate;
        return $this;
    }
    /**
     * Get Language value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DataElementType|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $language
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType
     */
    public function setLanguage(\Webservice\Service\Dto\SmevSoap\StructType\DataElementType $language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Schedule value
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DataElementType|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param \Webservice\Service\Dto\SmevSoap\StructType\DataElementType $schedule
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType
     */
    public function setSchedule(\Webservice\Service\Dto\SmevSoap\StructType\DataElementType $schedule = null)
    {
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get AgreementOnFullDayGroup value
     * @return bool|null
     */
    public function getAgreementOnFullDayGroup()
    {
        return $this->AgreementOnFullDayGroup;
    }
    /**
     * Set AgreementOnFullDayGroup value
     * @param bool $agreementOnFullDayGroup
     * @return \Webservice\Service\Dto\SmevSoap\StructType\EntryParamsType
     */
    public function setAgreementOnFullDayGroup($agreementOnFullDayGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($agreementOnFullDayGroup) && !is_bool($agreementOnFullDayGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($agreementOnFullDayGroup, true), gettype($agreementOnFullDayGroup)), __LINE__);
        }
        $this->AgreementOnFullDayGroup = $agreementOnFullDayGroup;
        return $this;
    }
}
