<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Описание документа
 * @subpackage Structs
 */
class DocInfoType extends AbstractStructBase
{
    /**
     * The DocIssueDate
     * @var string
     */
    public $DocIssueDate;
    /**
     * The DocIssued
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $DocIssued;
    /**
     * The DocExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocExpirationDate;
    /**
     * Constructor method for DocInfoType
     * @uses DocInfoType::setDocIssueDate()
     * @uses DocInfoType::setDocIssued()
     * @uses DocInfoType::setDocExpirationDate()
     * @param string $docIssueDate
     * @param string $docIssued
     * @param string $docExpirationDate
     */
    public function __construct($docIssueDate = null, $docIssued = null, $docExpirationDate = null)
    {
        $this
            ->setDocIssueDate($docIssueDate)
            ->setDocIssued($docIssued)
            ->setDocExpirationDate($docExpirationDate);
    }
    /**
     * Get DocIssueDate value
     * @return string|null
     */
    public function getDocIssueDate()
    {
        return $this->DocIssueDate;
    }
    /**
     * Set DocIssueDate value
     * @param string $docIssueDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType
     */
    public function setDocIssueDate($docIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueDate) && !is_string($docIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueDate, true), gettype($docIssueDate)), __LINE__);
        }
        $this->DocIssueDate = $docIssueDate;
        return $this;
    }
    /**
     * Get DocIssued value
     * @return string|null
     */
    public function getDocIssued()
    {
        return $this->DocIssued;
    }
    /**
     * Set DocIssued value
     * @param string $docIssued
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType
     */
    public function setDocIssued($docIssued = null)
    {
        // validation for constraint: string
        if (!is_null($docIssued) && !is_string($docIssued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssued, true), gettype($docIssued)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($docIssued) && mb_strlen($docIssued) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($docIssued)), __LINE__);
        }
        $this->DocIssued = $docIssued;
        return $this;
    }
    /**
     * Get DocExpirationDate value
     * @return string|null
     */
    public function getDocExpirationDate()
    {
        return $this->DocExpirationDate;
    }
    /**
     * Set DocExpirationDate value
     * @param string $docExpirationDate
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DocInfoType
     */
    public function setDocExpirationDate($docExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($docExpirationDate) && !is_string($docExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docExpirationDate, true), gettype($docExpirationDate)), __LINE__);
        }
        $this->DocExpirationDate = $docExpirationDate;
        return $this;
    }
}
