<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataElementType StructType
 * Meta information extracted from the WSDL
 * - base: xsd:string
 * - maxLength: 256
 * @subpackage Structs
 */
class DataElementType extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - use: required
     * @var string
     */
    public $code;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 256
     * @var string
     */
    public $_;
    /**
     * Constructor method for DataElementType
     * @uses DataElementType::setCode()
     * @uses DataElementType::set_()
     * @param string $code
     * @param string $_
     */
    public function __construct($code = null, $_ = null)
    {
        $this
            ->setCode($code)
            ->set_($_);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DataElementType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($code) && mb_strlen($code) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Webservice\Service\Dto\SmevSoap\StructType\DataElementType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($_) && mb_strlen($_) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
