<?php

namespace Webservice\Service\Dto\SmevSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationQueueResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Данные о позиции при распределении
 * @subpackage Structs
 */
class ApplicationQueueResponseType extends AbstractStructBase
{
    /**
     * The orderId
     * @var int
     */
    public $orderId;
    /**
     * The Position
     * @var int
     */
    public $Position;
    /**
     * The Total
     * @var int
     */
    public $Total;
    /**
     * The WithoutQueue
     * @var int
     */
    public $WithoutQueue;
    /**
     * The FirstQueue
     * @var int
     */
    public $FirstQueue;
    /**
     * The AdvantageQueue
     * @var int
     */
    public $AdvantageQueue;
    /**
     * The RelevantDT
     * @var string
     */
    public $RelevantDT;
    /**
     * Constructor method for ApplicationQueueResponseType
     * @uses ApplicationQueueResponseType::setOrderId()
     * @uses ApplicationQueueResponseType::setPosition()
     * @uses ApplicationQueueResponseType::setTotal()
     * @uses ApplicationQueueResponseType::setWithoutQueue()
     * @uses ApplicationQueueResponseType::setFirstQueue()
     * @uses ApplicationQueueResponseType::setAdvantageQueue()
     * @uses ApplicationQueueResponseType::setRelevantDT()
     * @param int $orderId
     * @param int $position
     * @param int $total
     * @param int $withoutQueue
     * @param int $firstQueue
     * @param int $advantageQueue
     * @param string $relevantDT
     */
    public function __construct($orderId = null, $position = null, $total = null, $withoutQueue = null, $firstQueue = null, $advantageQueue = null, $relevantDT = null)
    {
        $this
            ->setOrderId($orderId)
            ->setPosition($position)
            ->setTotal($total)
            ->setWithoutQueue($withoutQueue)
            ->setFirstQueue($firstQueue)
            ->setAdvantageQueue($advantageQueue)
            ->setRelevantDT($relevantDT);
    }
    /**
     * Get orderId value
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get Position value
     * @return int|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param int $total
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !(is_int($total) || ctype_digit($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get WithoutQueue value
     * @return int|null
     */
    public function getWithoutQueue()
    {
        return $this->WithoutQueue;
    }
    /**
     * Set WithoutQueue value
     * @param int $withoutQueue
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setWithoutQueue($withoutQueue = null)
    {
        // validation for constraint: int
        if (!is_null($withoutQueue) && !(is_int($withoutQueue) || ctype_digit($withoutQueue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($withoutQueue, true), gettype($withoutQueue)), __LINE__);
        }
        $this->WithoutQueue = $withoutQueue;
        return $this;
    }
    /**
     * Get FirstQueue value
     * @return int|null
     */
    public function getFirstQueue()
    {
        return $this->FirstQueue;
    }
    /**
     * Set FirstQueue value
     * @param int $firstQueue
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setFirstQueue($firstQueue = null)
    {
        // validation for constraint: int
        if (!is_null($firstQueue) && !(is_int($firstQueue) || ctype_digit($firstQueue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstQueue, true), gettype($firstQueue)), __LINE__);
        }
        $this->FirstQueue = $firstQueue;
        return $this;
    }
    /**
     * Get AdvantageQueue value
     * @return int|null
     */
    public function getAdvantageQueue()
    {
        return $this->AdvantageQueue;
    }
    /**
     * Set AdvantageQueue value
     * @param int $advantageQueue
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setAdvantageQueue($advantageQueue = null)
    {
        // validation for constraint: int
        if (!is_null($advantageQueue) && !(is_int($advantageQueue) || ctype_digit($advantageQueue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($advantageQueue, true), gettype($advantageQueue)), __LINE__);
        }
        $this->AdvantageQueue = $advantageQueue;
        return $this;
    }
    /**
     * Get RelevantDT value
     * @return string|null
     */
    public function getRelevantDT()
    {
        return $this->RelevantDT;
    }
    /**
     * Set RelevantDT value
     * @param string $relevantDT
     * @return \Webservice\Service\Dto\SmevSoap\StructType\ApplicationQueueResponseType
     */
    public function setRelevantDT($relevantDT = null)
    {
        // validation for constraint: string
        if (!is_null($relevantDT) && !is_string($relevantDT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relevantDT, true), gettype($relevantDT)), __LINE__);
        }
        $this->RelevantDT = $relevantDT;
        return $this;
    }
}
