<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sezione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sezione
 * @subpackage Structs
 */
class Sezione extends AbstractStructBase
{
    /**
     * The Coordinate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Coordinate
     */
    public $Coordinate;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The DistanzaMinimaPresenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DistanzaMinimaPresenza;
    /**
     * The GruppiTurni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGruppoTurni
     */
    public $GruppiTurni;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The Predefinito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Predefinito;
    /**
     * Constructor method for Sezione
     * @uses Sezione::setCoordinate()
     * @uses Sezione::setDescrizione()
     * @uses Sezione::setDistanzaMinimaPresenza()
     * @uses Sezione::setGruppiTurni()
     * @uses Sezione::setID()
     * @uses Sezione::setPredefinito()
     * @param \StructType\Coordinate $coordinate
     * @param string $descrizione
     * @param int $distanzaMinimaPresenza
     * @param \ArrayType\ArrayOfGruppoTurni $gruppiTurni
     * @param string $iD
     * @param bool $predefinito
     */
    public function __construct(\StructType\Coordinate $coordinate = null, $descrizione = null, $distanzaMinimaPresenza = null, \ArrayType\ArrayOfGruppoTurni $gruppiTurni = null, $iD = null, $predefinito = null)
    {
        $this
            ->setCoordinate($coordinate)
            ->setDescrizione($descrizione)
            ->setDistanzaMinimaPresenza($distanzaMinimaPresenza)
            ->setGruppiTurni($gruppiTurni)
            ->setID($iD)
            ->setPredefinito($predefinito);
    }
    /**
     * Get Coordinate value
     * @return \StructType\Coordinate|null
     */
    public function getCoordinate()
    {
        return $this->Coordinate;
    }
    /**
     * Set Coordinate value
     * @param \StructType\Coordinate $coordinate
     * @return \StructType\Sezione
     */
    public function setCoordinate(\StructType\Coordinate $coordinate = null)
    {
        $this->Coordinate = $coordinate;
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\Sezione
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get DistanzaMinimaPresenza value
     * @return int|null
     */
    public function getDistanzaMinimaPresenza()
    {
        return $this->DistanzaMinimaPresenza;
    }
    /**
     * Set DistanzaMinimaPresenza value
     * @param int $distanzaMinimaPresenza
     * @return \StructType\Sezione
     */
    public function setDistanzaMinimaPresenza($distanzaMinimaPresenza = null)
    {
        // validation for constraint: int
        if (!is_null($distanzaMinimaPresenza) && !(is_int($distanzaMinimaPresenza) || ctype_digit($distanzaMinimaPresenza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distanzaMinimaPresenza, true), gettype($distanzaMinimaPresenza)), __LINE__);
        }
        $this->DistanzaMinimaPresenza = $distanzaMinimaPresenza;
        return $this;
    }
    /**
     * Get GruppiTurni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGruppoTurni|null
     */
    public function getGruppiTurni()
    {
        return isset($this->GruppiTurni) ? $this->GruppiTurni : null;
    }
    /**
     * Set GruppiTurni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGruppoTurni $gruppiTurni
     * @return \StructType\Sezione
     */
    public function setGruppiTurni(\ArrayType\ArrayOfGruppoTurni $gruppiTurni = null)
    {
        if (is_null($gruppiTurni) || (is_array($gruppiTurni) && empty($gruppiTurni))) {
            unset($this->GruppiTurni);
        } else {
            $this->GruppiTurni = $gruppiTurni;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\Sezione
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Predefinito value
     * @return bool|null
     */
    public function getPredefinito()
    {
        return $this->Predefinito;
    }
    /**
     * Set Predefinito value
     * @param bool $predefinito
     * @return \StructType\Sezione
     */
    public function setPredefinito($predefinito = null)
    {
        // validation for constraint: boolean
        if (!is_null($predefinito) && !is_bool($predefinito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($predefinito, true), gettype($predefinito)), __LINE__);
        }
        $this->Predefinito = $predefinito;
        return $this;
    }
}
