<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendCorsoRegistrazione StructType
 * @subpackage Structs
 */
class SendCorsoRegistrazione extends AbstractStructBase
{
    /**
     * The Esercizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esercizio;
    /**
     * The Numeratore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numeratore;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Numero;
    /**
     * The Riga
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Riga;
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The Annotazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Annotazioni;
    /**
     * The IsAggiornamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAggiornamento;
    /**
     * Constructor method for SendCorsoRegistrazione
     * @uses SendCorsoRegistrazione::setEsercizio()
     * @uses SendCorsoRegistrazione::setNumeratore()
     * @uses SendCorsoRegistrazione::setNumero()
     * @uses SendCorsoRegistrazione::setRiga()
     * @uses SendCorsoRegistrazione::setIDAnagrafe()
     * @uses SendCorsoRegistrazione::setAnnotazioni()
     * @uses SendCorsoRegistrazione::setIsAggiornamento()
     * @param string $esercizio
     * @param string $numeratore
     * @param int $numero
     * @param int $riga
     * @param int $iDAnagrafe
     * @param string $annotazioni
     * @param bool $isAggiornamento
     */
    public function __construct($esercizio = null, $numeratore = null, $numero = null, $riga = null, $iDAnagrafe = null, $annotazioni = null, $isAggiornamento = null)
    {
        $this
            ->setEsercizio($esercizio)
            ->setNumeratore($numeratore)
            ->setNumero($numero)
            ->setRiga($riga)
            ->setIDAnagrafe($iDAnagrafe)
            ->setAnnotazioni($annotazioni)
            ->setIsAggiornamento($isAggiornamento);
    }
    /**
     * Get Esercizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsercizio()
    {
        return isset($this->Esercizio) ? $this->Esercizio : null;
    }
    /**
     * Set Esercizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esercizio
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setEsercizio($esercizio = null)
    {
        // validation for constraint: string
        if (!is_null($esercizio) && !is_string($esercizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esercizio, true), gettype($esercizio)), __LINE__);
        }
        if (is_null($esercizio) || (is_array($esercizio) && empty($esercizio))) {
            unset($this->Esercizio);
        } else {
            $this->Esercizio = $esercizio;
        }
        return $this;
    }
    /**
     * Get Numeratore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeratore()
    {
        return isset($this->Numeratore) ? $this->Numeratore : null;
    }
    /**
     * Set Numeratore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeratore
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setNumeratore($numeratore = null)
    {
        // validation for constraint: string
        if (!is_null($numeratore) && !is_string($numeratore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeratore, true), gettype($numeratore)), __LINE__);
        }
        if (is_null($numeratore) || (is_array($numeratore) && empty($numeratore))) {
            unset($this->Numeratore);
        } else {
            $this->Numeratore = $numeratore;
        }
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Riga value
     * @return int|null
     */
    public function getRiga()
    {
        return $this->Riga;
    }
    /**
     * Set Riga value
     * @param int $riga
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setRiga($riga = null)
    {
        // validation for constraint: int
        if (!is_null($riga) && !(is_int($riga) || ctype_digit($riga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($riga, true), gettype($riga)), __LINE__);
        }
        $this->Riga = $riga;
        return $this;
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get Annotazioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnotazioni()
    {
        return isset($this->Annotazioni) ? $this->Annotazioni : null;
    }
    /**
     * Set Annotazioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annotazioni
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setAnnotazioni($annotazioni = null)
    {
        // validation for constraint: string
        if (!is_null($annotazioni) && !is_string($annotazioni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annotazioni, true), gettype($annotazioni)), __LINE__);
        }
        if (is_null($annotazioni) || (is_array($annotazioni) && empty($annotazioni))) {
            unset($this->Annotazioni);
        } else {
            $this->Annotazioni = $annotazioni;
        }
        return $this;
    }
    /**
     * Get IsAggiornamento value
     * @return bool|null
     */
    public function getIsAggiornamento()
    {
        return $this->IsAggiornamento;
    }
    /**
     * Set IsAggiornamento value
     * @param bool $isAggiornamento
     * @return \StructType\SendCorsoRegistrazione
     */
    public function setIsAggiornamento($isAggiornamento = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAggiornamento) && !is_bool($isAggiornamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAggiornamento, true), gettype($isAggiornamento)), __LINE__);
        }
        $this->IsAggiornamento = $isAggiornamento;
        return $this;
    }
}
