<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVersion $parameters
     * @return \StructType\GetVersionResponse|bool
     */
    public function GetVersion(\StructType\GetVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInternalProtocolVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInternalProtocolVersion $parameters
     * @return \StructType\GetInternalProtocolVersionResponse|bool
     */
    public function GetInternalProtocolVersion(\StructType\GetInternalProtocolVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInternalProtocolVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfilo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProfilo $parameters
     * @return \StructType\GetProfiloResponse|bool
     */
    public function GetProfilo(\StructType\GetProfilo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfilo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigurazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConfigurazione $parameters
     * @return \StructType\GetConfigurazioneResponse|bool
     */
    public function GetConfigurazione(\StructType\GetConfigurazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConfigurazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCheckList_Richieste
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCheckList_Richieste $parameters
     * @return \StructType\GetCheckList_RichiesteResponse|bool
     */
    public function GetCheckList_Richieste(\StructType\GetCheckList_Richieste $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCheckList_Richieste($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegioni $parameters
     * @return \StructType\GetRegioniResponse|bool
     */
    public function GetRegioni(\StructType\GetRegioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRegioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProvince
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProvince $parameters
     * @return \StructType\GetProvinceResponse|bool
     */
    public function GetProvince(\StructType\GetProvince $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProvince($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetComuni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetComuni $parameters
     * @return \StructType\GetComuniResponse|bool
     */
    public function GetComuni(\StructType\GetComuni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetComuni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecapiti $parameters
     * @return \StructType\GetRecapitiResponse|bool
     */
    public function GetRecapiti(\StructType\GetRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecapito $parameters
     * @return \StructType\GetRecapitoResponse|bool
     */
    public function GetRecapito(\StructType\GetRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQualifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQualifiche $parameters
     * @return \StructType\GetQualificheResponse|bool
     */
    public function GetQualifiche(\StructType\GetQualifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQualifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCorsi $parameters
     * @return \StructType\GetCorsiResponse|bool
     */
    public function GetCorsi(\StructType\GetCorsi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsiUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCorsiUtente $parameters
     * @return \StructType\GetCorsiUtenteResponse|bool
     */
    public function GetCorsiUtente(\StructType\GetCorsiUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsiUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurni $parameters
     * @return \StructType\GetTurniResponse|bool
     */
    public function GetTurni(\StructType\GetTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurniOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurniOperatore $parameters
     * @return \StructType\GetTurniOperatoreResponse|bool
     */
    public function GetTurniOperatore(\StructType\GetTurniOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurniOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventiOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventiOperatore $parameters
     * @return \StructType\GetEventiOperatoreResponse|bool
     */
    public function GetEventiOperatore(\StructType\GetEventiOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventiOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarioTurni $parameters
     * @return \StructType\GetCalendarioTurniResponse|bool
     */
    public function GetCalendarioTurni(\StructType\GetCalendarioTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurniLite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarioTurniLite $parameters
     * @return \StructType\GetCalendarioTurniLiteResponse|bool
     */
    public function GetCalendarioTurniLite(\StructType\GetCalendarioTurniLite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurniLite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventi $parameters
     * @return \StructType\GetEventiResponse|bool
     */
    public function GetEventi(\StructType\GetEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarioEventi $parameters
     * @return \StructType\GetCalendarioEventiResponse|bool
     */
    public function GetCalendarioEventi(\StructType\GetCalendarioEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurnoSpecifico $parameters
     * @return \StructType\GetTurnoSpecificoResponse|bool
     */
    public function GetTurnoSpecifico(\StructType\GetTurnoSpecifico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurnoSpecifico2 $parameters
     * @return \StructType\GetTurnoSpecifico2Response|bool
     */
    public function GetTurnoSpecifico2(\StructType\GetTurnoSpecifico2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGiornoEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGiornoEvento $parameters
     * @return \StructType\GetGiornoEventoResponse|bool
     */
    public function GetGiornoEvento(\StructType\GetGiornoEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGiornoEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAttivitaUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttivitaUtente $parameters
     * @return \StructType\GetAttivitaUtenteResponse|bool
     */
    public function GetAttivitaUtente(\StructType\GetAttivitaUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAttivitaUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessaggi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMessaggi $parameters
     * @return \StructType\GetMessaggiResponse|bool
     */
    public function GetMessaggi(\StructType\GetMessaggi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessaggi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastPresenza $parameters
     * @return \StructType\GetLastPresenzaResponse|bool
     */
    public function GetLastPresenza(\StructType\GetLastPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastPresenza2 $parameters
     * @return \StructType\GetLastPresenza2Response|bool
     */
    public function GetLastPresenza2(\StructType\GetLastPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNotifiche $parameters
     * @return \StructType\GetNotificheResponse|bool
     */
    public function GetNotifiche(\StructType\GetNotifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestoNotifica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTestoNotifica $parameters
     * @return \StructType\GetTestoNotificaResponse|bool
     */
    public function GetTestoNotifica(\StructType\GetTestoNotifica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestoNotifica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTotaleNotificheDaNotificare
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTotaleNotificheDaNotificare $parameters
     * @return \StructType\GetTotaleNotificheDaNotificareResponse|bool
     */
    public function GetTotaleNotificheDaNotificare(\StructType\GetTotaleNotificheDaNotificare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTotaleNotificheDaNotificare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnagrafe $parameters
     * @return \StructType\GetAnagrafeResponse|bool
     */
    public function GetAnagrafe(\StructType\GetAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSociConRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCsvSociConRecapito $parameters
     * @return \StructType\GetCsvSociConRecapitoResponse|bool
     */
    public function GetCsvSociConRecapito(\StructType\GetCsvSociConRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSociConRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSituazionePrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCsvSituazionePrivacy $parameters
     * @return \StructType\GetCsvSituazionePrivacyResponse|bool
     */
    public function GetCsvSituazionePrivacy(\StructType\GetCsvSituazionePrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSituazionePrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvCampagnaSoci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCsvCampagnaSoci $parameters
     * @return \StructType\GetCsvCampagnaSociResponse|bool
     */
    public function GetCsvCampagnaSoci(\StructType\GetCsvCampagnaSoci $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvCampagnaSoci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaSegnalazioniGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaSegnalazioniGuasto $parameters
     * @return \StructType\GetListaSegnalazioniGuastoResponse|bool
     */
    public function GetListaSegnalazioniGuasto(\StructType\GetListaSegnalazioniGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaSegnalazioniGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaArticoliSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaArticoliSegnalazioneGuasto $parameters
     * @return \StructType\GetListaArticoliSegnalazioneGuastoResponse|bool
     */
    public function GetListaArticoliSegnalazioneGuasto(\StructType\GetListaArticoliSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaArticoliSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiesteCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRichiesteCartellino $parameters
     * @return \StructType\GetRichiesteCartellinoResponse|bool
     */
    public function GetRichiesteCartellino(\StructType\GetRichiesteCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiesteCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRichiestaCartellino $parameters
     * @return \StructType\GetRichiestaCartellinoResponse|bool
     */
    public function GetRichiestaCartellino(\StructType\GetRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaRuoliOperatori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaRuoliOperatori $parameters
     * @return \StructType\GetListaRuoliOperatoriResponse|bool
     */
    public function GetListaRuoliOperatori(\StructType\GetListaRuoliOperatori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaRuoliOperatori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaStradari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaStradari $parameters
     * @return \StructType\GetListaStradariResponse|bool
     */
    public function GetListaStradari(\StructType\GetListaStradari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaStradari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAnagrafeResponse|\StructType\GetAttivitaUtenteResponse|\StructType\GetCalendarioEventiResponse|\StructType\GetCalendarioTurniLiteResponse|\StructType\GetCalendarioTurniResponse|\StructType\GetCheckList_RichiesteResponse|\StructType\GetComuniResponse|\StructType\GetConfigurazioneResponse|\StructType\GetCorsiResponse|\StructType\GetCorsiUtenteResponse|\StructType\GetCsvCampagnaSociResponse|\StructType\GetCsvSituazionePrivacyResponse|\StructType\GetCsvSociConRecapitoResponse|\StructType\GetEventiOperatoreResponse|\StructType\GetEventiResponse|\StructType\GetGiornoEventoResponse|\StructType\GetInternalProtocolVersionResponse|\StructType\GetLastPresenza2Response|\StructType\GetLastPresenzaResponse|\StructType\GetListaArticoliSegnalazioneGuastoResponse|\StructType\GetListaRuoliOperatoriResponse|\StructType\GetListaSegnalazioniGuastoResponse|\StructType\GetListaStradariResponse|\StructType\GetMessaggiResponse|\StructType\GetNotificheResponse|\StructType\GetProfiloResponse|\StructType\GetProvinceResponse|\StructType\GetQualificheResponse|\StructType\GetRecapitiResponse|\StructType\GetRecapitoResponse|\StructType\GetRegioniResponse|\StructType\GetRichiestaCartellinoResponse|\StructType\GetRichiesteCartellinoResponse|\StructType\GetTestoNotificaResponse|\StructType\GetTotaleNotificheDaNotificareResponse|\StructType\GetTurniOperatoreResponse|\StructType\GetTurniResponse|\StructType\GetTurnoSpecifico2Response|\StructType\GetTurnoSpecificoResponse|\StructType\GetVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
