<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckGreenPassResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckGreenPassResponse
 * @subpackage Structs
 */
class CheckGreenPassResponse extends WebService_GenericResult
{
    /**
     * The Cognome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cognome;
    /**
     * The DataDiNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDiNascita;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The TipoGreenPass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoGreenPass;
    /**
     * The CheckGreenPassResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CheckGreenPassResponse
     */
    public $CheckGreenPassResult;
    /**
     * Constructor method for CheckGreenPassResponse
     * @uses CheckGreenPassResponse::setCognome()
     * @uses CheckGreenPassResponse::setDataDiNascita()
     * @uses CheckGreenPassResponse::setNome()
     * @uses CheckGreenPassResponse::setTipoGreenPass()
     * @uses CheckGreenPassResponse::setCheckGreenPassResult()
     * @param string $cognome
     * @param string $dataDiNascita
     * @param string $nome
     * @param string $tipoGreenPass
     * @param \StructType\CheckGreenPassResponse $checkGreenPassResult
     */
    public function __construct($cognome = null, $dataDiNascita = null, $nome = null, $tipoGreenPass = null, \StructType\CheckGreenPassResponse $checkGreenPassResult = null)
    {
        $this
            ->setCognome($cognome)
            ->setDataDiNascita($dataDiNascita)
            ->setNome($nome)
            ->setTipoGreenPass($tipoGreenPass)
            ->setCheckGreenPassResult($checkGreenPassResult);
    }
    /**
     * Get Cognome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCognome()
    {
        return isset($this->Cognome) ? $this->Cognome : null;
    }
    /**
     * Set Cognome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cognome
     * @return \StructType\CheckGreenPassResponse
     */
    public function setCognome($cognome = null)
    {
        // validation for constraint: string
        if (!is_null($cognome) && !is_string($cognome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognome, true), gettype($cognome)), __LINE__);
        }
        if (is_null($cognome) || (is_array($cognome) && empty($cognome))) {
            unset($this->Cognome);
        } else {
            $this->Cognome = $cognome;
        }
        return $this;
    }
    /**
     * Get DataDiNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDiNascita()
    {
        return isset($this->DataDiNascita) ? $this->DataDiNascita : null;
    }
    /**
     * Set DataDiNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDiNascita
     * @return \StructType\CheckGreenPassResponse
     */
    public function setDataDiNascita($dataDiNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataDiNascita) && !is_string($dataDiNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDiNascita, true), gettype($dataDiNascita)), __LINE__);
        }
        if (is_null($dataDiNascita) || (is_array($dataDiNascita) && empty($dataDiNascita))) {
            unset($this->DataDiNascita);
        } else {
            $this->DataDiNascita = $dataDiNascita;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\CheckGreenPassResponse
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get TipoGreenPass value
     * @return string|null
     */
    public function getTipoGreenPass()
    {
        return $this->TipoGreenPass;
    }
    /**
     * Set TipoGreenPass value
     * @uses \EnumType\DGCType::valueIsValid()
     * @uses \EnumType\DGCType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoGreenPass
     * @return \StructType\CheckGreenPassResponse
     */
    public function setTipoGreenPass($tipoGreenPass = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DGCType::valueIsValid($tipoGreenPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DGCType', is_array($tipoGreenPass) ? implode(', ', $tipoGreenPass) : var_export($tipoGreenPass, true), implode(', ', \EnumType\DGCType::getValidValues())), __LINE__);
        }
        $this->TipoGreenPass = $tipoGreenPass;
        return $this;
    }
    /**
     * Get CheckGreenPassResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CheckGreenPassResponse|null
     */
    public function getCheckGreenPassResult()
    {
        return isset($this->CheckGreenPassResult) ? $this->CheckGreenPassResult : null;
    }
    /**
     * Set CheckGreenPassResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CheckGreenPassResponse $checkGreenPassResult
     * @return \StructType\CheckGreenPassResponse
     */
    public function setCheckGreenPassResult(\StructType\CheckGreenPassResponse $checkGreenPassResult = null)
    {
        if (is_null($checkGreenPassResult) || (is_array($checkGreenPassResult) && empty($checkGreenPassResult))) {
            unset($this->CheckGreenPassResult);
        } else {
            $this->CheckGreenPassResult = $checkGreenPassResult;
        }
        return $this;
    }
}
