<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anagrafe_Get_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Anagrafe_Get_Result
 * @subpackage Structs
 */
class Anagrafe_Get_Result extends WebService_GenericResult
{
    /**
     * The Anagrafica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AnagraficaDettaglio_Model
     */
    public $Anagrafica;
    /**
     * The ComuniDomicilio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $ComuniDomicilio;
    /**
     * The ComuniNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $ComuniNascita;
    /**
     * The ComuniResidenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $ComuniResidenza;
    /**
     * Constructor method for Anagrafe_Get_Result
     * @uses Anagrafe_Get_Result::setAnagrafica()
     * @uses Anagrafe_Get_Result::setComuniDomicilio()
     * @uses Anagrafe_Get_Result::setComuniNascita()
     * @uses Anagrafe_Get_Result::setComuniResidenza()
     * @param \StructType\AnagraficaDettaglio_Model $anagrafica
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza
     */
    public function __construct(\StructType\AnagraficaDettaglio_Model $anagrafica = null, \ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio = null, \ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita = null, \ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza = null)
    {
        $this
            ->setAnagrafica($anagrafica)
            ->setComuniDomicilio($comuniDomicilio)
            ->setComuniNascita($comuniNascita)
            ->setComuniResidenza($comuniResidenza);
    }
    /**
     * Get Anagrafica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AnagraficaDettaglio_Model|null
     */
    public function getAnagrafica()
    {
        return isset($this->Anagrafica) ? $this->Anagrafica : null;
    }
    /**
     * Set Anagrafica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AnagraficaDettaglio_Model $anagrafica
     * @return \StructType\Anagrafe_Get_Result
     */
    public function setAnagrafica(\StructType\AnagraficaDettaglio_Model $anagrafica = null)
    {
        if (is_null($anagrafica) || (is_array($anagrafica) && empty($anagrafica))) {
            unset($this->Anagrafica);
        } else {
            $this->Anagrafica = $anagrafica;
        }
        return $this;
    }
    /**
     * Get ComuniDomicilio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getComuniDomicilio()
    {
        return isset($this->ComuniDomicilio) ? $this->ComuniDomicilio : null;
    }
    /**
     * Set ComuniDomicilio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio
     * @return \StructType\Anagrafe_Get_Result
     */
    public function setComuniDomicilio(\ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio = null)
    {
        if (is_null($comuniDomicilio) || (is_array($comuniDomicilio) && empty($comuniDomicilio))) {
            unset($this->ComuniDomicilio);
        } else {
            $this->ComuniDomicilio = $comuniDomicilio;
        }
        return $this;
    }
    /**
     * Get ComuniNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getComuniNascita()
    {
        return isset($this->ComuniNascita) ? $this->ComuniNascita : null;
    }
    /**
     * Set ComuniNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita
     * @return \StructType\Anagrafe_Get_Result
     */
    public function setComuniNascita(\ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita = null)
    {
        if (is_null($comuniNascita) || (is_array($comuniNascita) && empty($comuniNascita))) {
            unset($this->ComuniNascita);
        } else {
            $this->ComuniNascita = $comuniNascita;
        }
        return $this;
    }
    /**
     * Get ComuniResidenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getComuniResidenza()
    {
        return isset($this->ComuniResidenza) ? $this->ComuniResidenza : null;
    }
    /**
     * Set ComuniResidenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza
     * @return \StructType\Anagrafe_Get_Result
     */
    public function setComuniResidenza(\ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza = null)
    {
        if (is_null($comuniResidenza) || (is_array($comuniResidenza) && empty($comuniResidenza))) {
            unset($this->ComuniResidenza);
        } else {
            $this->ComuniResidenza = $comuniResidenza;
        }
        return $this;
    }
}
