<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for RequestState EnumType
 * @subpackage Enumerations
 */
class RequestState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'InvalidArgument'
     * @return string 'InvalidArgument'
     */
    const VALUE_INVALID_ARGUMENT = 'InvalidArgument';
    /**
     * Constant for value 'ValError'
     * @return string 'ValError'
     */
    const VALUE_VAL_ERROR = 'ValError';
    /**
     * Constant for value 'OtherError'
     * @return string 'OtherError'
     */
    const VALUE_OTHER_ERROR = 'OtherError';
    /**
     * Constant for value 'NothingFound'
     * @return string 'NothingFound'
     */
    const VALUE_NOTHING_FOUND = 'NothingFound';
    /**
     * Constant for value 'NotAuthorized'
     * @return string 'NotAuthorized'
     */
    const VALUE_NOT_AUTHORIZED = 'NotAuthorized';
    /**
     * Constant for value 'InvalidSignature'
     * @return string 'InvalidSignature'
     */
    const VALUE_INVALID_SIGNATURE = 'InvalidSignature';
    /**
     * Constant for value 'IncompleteResults'
     * @return string 'IncompleteResults'
     */
    const VALUE_INCOMPLETE_RESULTS = 'IncompleteResults';
    /**
     * Constant for value 'WrongState'
     * @return string 'WrongState'
     */
    const VALUE_WRONG_STATE = 'WrongState';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_INVALID_ARGUMENT
     * @uses self::VALUE_VAL_ERROR
     * @uses self::VALUE_OTHER_ERROR
     * @uses self::VALUE_NOTHING_FOUND
     * @uses self::VALUE_NOT_AUTHORIZED
     * @uses self::VALUE_INVALID_SIGNATURE
     * @uses self::VALUE_INCOMPLETE_RESULTS
     * @uses self::VALUE_WRONG_STATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_INVALID_ARGUMENT,
            self::VALUE_VAL_ERROR,
            self::VALUE_OTHER_ERROR,
            self::VALUE_NOTHING_FOUND,
            self::VALUE_NOT_AUTHORIZED,
            self::VALUE_INVALID_SIGNATURE,
            self::VALUE_INCOMPLETE_RESULTS,
            self::VALUE_WRONG_STATE,
        );
    }
}
