<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ReasonCode EnumType
 * @subpackage Enumerations
 */
class ReasonCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'SyntacticValidationError'
     * @return string 'SyntacticValidationError'
     */
    const VALUE_SYNTACTIC_VALIDATION_ERROR = 'SyntacticValidationError';
    /**
     * Constant for value 'RulesConditionasError'
     * @return string 'RulesConditionasError'
     */
    const VALUE_RULES_CONDITIONAS_ERROR = 'RulesConditionasError';
    /**
     * Constant for value 'InvalidMessageContent'
     * @return string 'InvalidMessageContent'
     */
    const VALUE_INVALID_MESSAGE_CONTENT = 'InvalidMessageContent';
    /**
     * Constant for value 'PeriodError'
     * @return string 'PeriodError'
     */
    const VALUE_PERIOD_ERROR = 'PeriodError';
    /**
     * Constant for value 'RoleError'
     * @return string 'RoleError'
     */
    const VALUE_ROLE_ERROR = 'RoleError';
    /**
     * Constant for value 'KeyTypeError'
     * @return string 'KeyTypeError'
     */
    const VALUE_KEY_TYPE_ERROR = 'KeyTypeError';
    /**
     * Constant for value 'InvalidMessageType'
     * @return string 'InvalidMessageType'
     */
    const VALUE_INVALID_MESSAGE_TYPE = 'InvalidMessageType';
    /**
     * Constant for value 'WrongDeclaredMessageType'
     * @return string 'WrongDeclaredMessageType'
     */
    const VALUE_WRONG_DECLARED_MESSAGE_TYPE = 'WrongDeclaredMessageType';
    /**
     * Constant for value 'NotSupportedMessageType'
     * @return string 'NotSupportedMessageType'
     */
    const VALUE_NOT_SUPPORTED_MESSAGE_TYPE = 'NotSupportedMessageType';
    /**
     * Constant for value 'NotSupportedDomain'
     * @return string 'NotSupportedDomain'
     */
    const VALUE_NOT_SUPPORTED_DOMAIN = 'NotSupportedDomain';
    /**
     * Constant for value 'WrongCredentials'
     * @return string 'WrongCredentials'
     */
    const VALUE_WRONG_CREDENTIALS = 'WrongCredentials';
    /**
     * Constant for value 'CredentialsNotMatching'
     * @return string 'CredentialsNotMatching'
     */
    const VALUE_CREDENTIALS_NOT_MATCHING = 'CredentialsNotMatching';
    /**
     * Constant for value 'NoTraderAuthorization'
     * @return string 'NoTraderAuthorization'
     */
    const VALUE_NO_TRADER_AUTHORIZATION = 'NoTraderAuthorization';
    /**
     * Constant for value 'NoSignatureFound'
     * @return string 'NoSignatureFound'
     */
    const VALUE_NO_SIGNATURE_FOUND = 'NoSignatureFound';
    /**
     * Constant for value 'WrongSignature'
     * @return string 'WrongSignature'
     */
    const VALUE_WRONG_SIGNATURE = 'WrongSignature';
    /**
     * Constant for value 'StateNotAcceptsMessageType'
     * @return string 'StateNotAcceptsMessageType'
     */
    const VALUE_STATE_NOT_ACCEPTS_MESSAGE_TYPE = 'StateNotAcceptsMessageType';
    /**
     * Constant for value 'TechnicalProblem'
     * @return string 'TechnicalProblem'
     */
    const VALUE_TECHNICAL_PROBLEM = 'TechnicalProblem';
    /**
     * Constant for value 'Failure'
     * @return string 'Failure'
     */
    const VALUE_FAILURE = 'Failure';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return allowed values
     * @uses self::VALUE_SYNTACTIC_VALIDATION_ERROR
     * @uses self::VALUE_RULES_CONDITIONAS_ERROR
     * @uses self::VALUE_INVALID_MESSAGE_CONTENT
     * @uses self::VALUE_PERIOD_ERROR
     * @uses self::VALUE_ROLE_ERROR
     * @uses self::VALUE_KEY_TYPE_ERROR
     * @uses self::VALUE_INVALID_MESSAGE_TYPE
     * @uses self::VALUE_WRONG_DECLARED_MESSAGE_TYPE
     * @uses self::VALUE_NOT_SUPPORTED_MESSAGE_TYPE
     * @uses self::VALUE_NOT_SUPPORTED_DOMAIN
     * @uses self::VALUE_WRONG_CREDENTIALS
     * @uses self::VALUE_CREDENTIALS_NOT_MATCHING
     * @uses self::VALUE_NO_TRADER_AUTHORIZATION
     * @uses self::VALUE_NO_SIGNATURE_FOUND
     * @uses self::VALUE_WRONG_SIGNATURE
     * @uses self::VALUE_STATE_NOT_ACCEPTS_MESSAGE_TYPE
     * @uses self::VALUE_TECHNICAL_PROBLEM
     * @uses self::VALUE_FAILURE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SYNTACTIC_VALIDATION_ERROR,
            self::VALUE_RULES_CONDITIONAS_ERROR,
            self::VALUE_INVALID_MESSAGE_CONTENT,
            self::VALUE_PERIOD_ERROR,
            self::VALUE_ROLE_ERROR,
            self::VALUE_KEY_TYPE_ERROR,
            self::VALUE_INVALID_MESSAGE_TYPE,
            self::VALUE_WRONG_DECLARED_MESSAGE_TYPE,
            self::VALUE_NOT_SUPPORTED_MESSAGE_TYPE,
            self::VALUE_NOT_SUPPORTED_DOMAIN,
            self::VALUE_WRONG_CREDENTIALS,
            self::VALUE_CREDENTIALS_NOT_MATCHING,
            self::VALUE_NO_TRADER_AUTHORIZATION,
            self::VALUE_NO_SIGNATURE_FOUND,
            self::VALUE_WRONG_SIGNATURE,
            self::VALUE_STATE_NOT_ACCEPTS_MESSAGE_TYPE,
            self::VALUE_TECHNICAL_PROBLEM,
            self::VALUE_FAILURE,
            self::VALUE_OTHER,
        );
    }
}
