<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestResultState StructType
 * @subpackage Structs
 */
class RequestResultState extends AbstractStructBase
{
    /**
     * The requestId
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $requestId;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The reasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reasonCode;
    /**
     * The explanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $explanation;
    /**
     * Constructor method for RequestResultState
     * @uses RequestResultState::setRequestId()
     * @uses RequestResultState::setStatus()
     * @uses RequestResultState::setReasonCode()
     * @uses RequestResultState::setExplanation()
     * @param string $requestId
     * @param string $status
     * @param string $reasonCode
     * @param string $explanation
     */
    public function __construct($requestId = null, $status = null, $reasonCode = null, $explanation = null)
    {
        $this
            ->setRequestId($requestId)
            ->setStatus($status)
            ->setReasonCode($reasonCode)
            ->setExplanation($explanation);
    }
    /**
     * Get requestId value
     * @return string
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\RequestResultState
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\RequestState::valueIsValid()
     * @uses \EnumType\RequestState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\RequestResultState
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestState::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RequestState', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\RequestState::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get reasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->reasonCode;
    }
    /**
     * Set reasonCode value
     * @uses \EnumType\ReasonCode::valueIsValid()
     * @uses \EnumType\ReasonCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reasonCode
     * @return \StructType\RequestResultState
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReasonCode::valueIsValid($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReasonCode', is_array($reasonCode) ? implode(', ', $reasonCode) : var_export($reasonCode, true), implode(', ', \EnumType\ReasonCode::getValidValues())), __LINE__);
        }
        $this->reasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get explanation value
     * @return string|null
     */
    public function getExplanation()
    {
        return $this->explanation;
    }
    /**
     * Set explanation value
     * @param string $explanation
     * @return \StructType\RequestResultState
     */
    public function setExplanation($explanation = null)
    {
        // validation for constraint: string
        if (!is_null($explanation) && !is_string($explanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanation, true), gettype($explanation)), __LINE__);
        }
        $this->explanation = $explanation;
        return $this;
    }
}
