<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageSubmissionRequest StructType
 * @subpackage Structs
 */
class MessageSubmissionRequest extends AbstractStructBase
{
    /**
     * The traderID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $traderID;
    /**
     * The wsUserID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $wsUserID;
    /**
     * The wsPass
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $wsPass;
    /**
     * The DigitallySignedMessage
     * @var \StructType\SubmittedXMLMessageInfo
     */
    public $DigitallySignedMessage;
    /**
     * Constructor method for MessageSubmissionRequest
     * @uses MessageSubmissionRequest::setTraderID()
     * @uses MessageSubmissionRequest::setWsUserID()
     * @uses MessageSubmissionRequest::setWsPass()
     * @uses MessageSubmissionRequest::setDigitallySignedMessage()
     * @param string $traderID
     * @param string $wsUserID
     * @param string $wsPass
     * @param \StructType\SubmittedXMLMessageInfo $digitallySignedMessage
     */
    public function __construct($traderID = null, $wsUserID = null, $wsPass = null, \StructType\SubmittedXMLMessageInfo $digitallySignedMessage = null)
    {
        $this
            ->setTraderID($traderID)
            ->setWsUserID($wsUserID)
            ->setWsPass($wsPass)
            ->setDigitallySignedMessage($digitallySignedMessage);
    }
    /**
     * Get traderID value
     * @return string
     */
    public function getTraderID()
    {
        return $this->traderID;
    }
    /**
     * Set traderID value
     * @param string $traderID
     * @return \StructType\MessageSubmissionRequest
     */
    public function setTraderID($traderID = null)
    {
        // validation for constraint: string
        if (!is_null($traderID) && !is_string($traderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traderID, true), gettype($traderID)), __LINE__);
        }
        $this->traderID = $traderID;
        return $this;
    }
    /**
     * Get wsUserID value
     * @return string
     */
    public function getWsUserID()
    {
        return $this->wsUserID;
    }
    /**
     * Set wsUserID value
     * @param string $wsUserID
     * @return \StructType\MessageSubmissionRequest
     */
    public function setWsUserID($wsUserID = null)
    {
        // validation for constraint: string
        if (!is_null($wsUserID) && !is_string($wsUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsUserID, true), gettype($wsUserID)), __LINE__);
        }
        $this->wsUserID = $wsUserID;
        return $this;
    }
    /**
     * Get wsPass value
     * @return string
     */
    public function getWsPass()
    {
        return $this->wsPass;
    }
    /**
     * Set wsPass value
     * @param string $wsPass
     * @return \StructType\MessageSubmissionRequest
     */
    public function setWsPass($wsPass = null)
    {
        // validation for constraint: string
        if (!is_null($wsPass) && !is_string($wsPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsPass, true), gettype($wsPass)), __LINE__);
        }
        $this->wsPass = $wsPass;
        return $this;
    }
    /**
     * Get DigitallySignedMessage value
     * @return \StructType\SubmittedXMLMessageInfo|null
     */
    public function getDigitallySignedMessage()
    {
        return $this->DigitallySignedMessage;
    }
    /**
     * Set DigitallySignedMessage value
     * @param \StructType\SubmittedXMLMessageInfo $digitallySignedMessage
     * @return \StructType\MessageSubmissionRequest
     */
    public function setDigitallySignedMessage(\StructType\SubmittedXMLMessageInfo $digitallySignedMessage = null)
    {
        $this->DigitallySignedMessage = $digitallySignedMessage;
        return $this;
    }
}
