<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubmittedXMLMessageInfo StructType
 * @subpackage Structs
 */
class SubmittedXMLMessageInfo extends AbstractStructBase
{
    /**
     * The messageType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $messageType;
    /**
     * The isXmlString
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $isXmlString;
    /**
     * The xmlMessage
     * @var mixed
     */
    public $xmlMessage;
    /**
     * Constructor method for SubmittedXMLMessageInfo
     * @uses SubmittedXMLMessageInfo::setMessageType()
     * @uses SubmittedXMLMessageInfo::setIsXmlString()
     * @uses SubmittedXMLMessageInfo::setXmlMessage()
     * @param string $messageType
     * @param bool $isXmlString
     * @param mixed $xmlMessage
     */
    public function __construct($messageType = null, $isXmlString = null, $xmlMessage = null)
    {
        $this
            ->setMessageType($messageType)
            ->setIsXmlString($isXmlString)
            ->setXmlMessage($xmlMessage);
    }
    /**
     * Get messageType value
     * @return string
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @uses \EnumType\MessageType::valueIsValid()
     * @uses \EnumType\MessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \StructType\SubmittedXMLMessageInfo
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageType', is_array($messageType) ? implode(', ', $messageType) : var_export($messageType, true), implode(', ', \EnumType\MessageType::getValidValues())), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get isXmlString value
     * @return bool
     */
    public function getIsXmlString()
    {
        return $this->isXmlString;
    }
    /**
     * Set isXmlString value
     * @param bool $isXmlString
     * @return \StructType\SubmittedXMLMessageInfo
     */
    public function setIsXmlString($isXmlString = null)
    {
        // validation for constraint: boolean
        if (!is_null($isXmlString) && !is_bool($isXmlString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isXmlString, true), gettype($isXmlString)), __LINE__);
        }
        $this->isXmlString = $isXmlString;
        return $this;
    }
    /**
     * Get xmlMessage value
     * @return mixed|null
     */
    public function getXmlMessage()
    {
        return $this->xmlMessage;
    }
    /**
     * Set xmlMessage value
     * @param mixed $xmlMessage
     * @return \StructType\SubmittedXMLMessageInfo
     */
    public function setXmlMessage($xmlMessage = null)
    {
        $this->xmlMessage = $xmlMessage;
        return $this;
    }
}
