<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named processIncomingMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessIncomingMessageRequest $parameters
     * @return \StructType\ProcessIncomingMessageResponse|bool
     */
    public function processIncomingMessage(\StructType\ProcessIncomingMessageRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->processIncomingMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessIncomingMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
