<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tranzakcio ServiceType
 * @subpackage Services
 */
class Tranzakcio extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TranzakcioAdatok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TranzakcioAdatok $parameters
     * @return \StructType\TranzakcioAdatokResponse|bool
     */
    public function TranzakcioAdatok(\StructType\TranzakcioAdatok $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TranzakcioAdatok($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TranzakcioAdatokEgy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TranzakcioAdatokEgy $parameters
     * @return \StructType\TranzakcioAdatokEgyResponse|bool
     */
    public function TranzakcioAdatokEgy(\StructType\TranzakcioAdatokEgy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TranzakcioAdatokEgy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TranzakcioAdatokEgyResponse|\StructType\TranzakcioAdatokResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
