<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sztorno ServiceType
 * @subpackage Services
 */
class Sztorno extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Sztorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Sztorno $parameters
     * @return \StructType\SztornoResponse|bool
     */
    public function Sztorno(\StructType\Sztorno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Sztorno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SztornoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
