<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://serviceteszt.kartyakozpont.hu/EngedelykeroService.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://serviceteszt.kartyakozpont.hu/EngedelykeroService.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Engedelykeres ServiceType
 */
$engedelykeres = new \ServiceType\Engedelykeres($options);
/**
 * Sample call for EngedelykeresElfogadohelyEgy operation/method
 */
if ($engedelykeres->EngedelykeresElfogadohelyEgy(new \StructType\EngedelykeresElfogadohelyEgy()) !== false) {
    print_r($engedelykeres->getResult());
} else {
    print_r($engedelykeres->getLastError());
}
/**
 * Sample call for EngedelykeresElfogadohelyWebshopEgy operation/method
 */
if ($engedelykeres->EngedelykeresElfogadohelyWebshopEgy(new \StructType\EngedelykeresElfogadohelyWebshopEgy()) !== false) {
    print_r($engedelykeres->getResult());
} else {
    print_r($engedelykeres->getLastError());
}
/**
 * Samples for Sztorno ServiceType
 */
$sztorno = new \ServiceType\Sztorno($options);
/**
 * Sample call for Sztorno operation/method
 */
if ($sztorno->Sztorno(new \StructType\Sztorno()) !== false) {
    print_r($sztorno->getResult());
} else {
    print_r($sztorno->getLastError());
}
/**
 * Samples for Tranzakcio ServiceType
 */
$tranzakcio = new \ServiceType\Tranzakcio($options);
/**
 * Sample call for TranzakcioAdatokEgy operation/method
 */
if ($tranzakcio->TranzakcioAdatokEgy(new \StructType\TranzakcioAdatokEgy()) !== false) {
    print_r($tranzakcio->getResult());
} else {
    print_r($tranzakcio->getLastError());
}
/**
 * Samples for Purchase ServiceType
 */
$purchase = new \ServiceType\Purchase($options);
/**
 * Sample call for purchaseWebshop operation/method
 */
if ($purchase->purchaseWebshop(new \StructType\PurchaseWebshop()) !== false) {
    print_r($purchase->getResult());
} else {
    print_r($purchase->getLastError());
}
