<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Purchase ServiceType
 * @subpackage Services
 */
class Purchase extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named purchaseWebshop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PurchaseWebshop $parameters
     * @return \StructType\PurchaseWebshopResponse|bool
     */
    public function purchaseWebshop(\StructType\PurchaseWebshop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->purchaseWebshop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PurchaseWebshopResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
