<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getResponseMerchantRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:getResponseMerchantRequest
 * @subpackage Structs
 */
class GetResponseMerchantRequest extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The issuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuerMerchantId;
    /**
     * The merchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $merchantTranId;
    /**
     * The terminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminalId;
    /**
     * Constructor method for getResponseMerchantRequest
     * @uses GetResponseMerchantRequest::setAmount()
     * @uses GetResponseMerchantRequest::setIssuerMerchantId()
     * @uses GetResponseMerchantRequest::setMerchantTranId()
     * @uses GetResponseMerchantRequest::setTerminalId()
     * @param int $amount
     * @param int $issuerMerchantId
     * @param string $merchantTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $issuerMerchantId = null, $merchantTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setMerchantTranId($merchantTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get issuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->issuerMerchantId;
    }
    /**
     * Set issuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->issuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get merchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return isset($this->merchantTranId) ? $this->merchantTranId : null;
    }
    /**
     * Set merchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantTranId
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        if (is_null($merchantTranId) || (is_array($merchantTranId) && empty($merchantTranId))) {
            unset($this->merchantTranId);
        } else {
            $this->merchantTranId = $merchantTranId;
        }
        return $this;
    }
    /**
     * Get terminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->terminalId) ? $this->terminalId : null;
    }
    /**
     * Set terminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->terminalId);
        } else {
            $this->terminalId = $terminalId;
        }
        return $this;
    }
}
