<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getResponseMerchantTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResponseMerchantTranId $parameters
     * @return \StructType\GetResponseMerchantTranIdResponse|bool
     */
    public function getResponseMerchantTranId(\StructType\GetResponseMerchantTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getResponseMerchantTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResponseIssuerTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResponseIssuerTranId $parameters
     * @return \StructType\GetResponseIssuerTranIdResponse|bool
     */
    public function getResponseIssuerTranId(\StructType\GetResponseIssuerTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getResponseIssuerTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetResponseIssuerTranIdResponse|\StructType\GetResponseMerchantTranIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
