<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reversal ServiceType
 * @subpackage Services
 */
class Reversal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reversalMerchantTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReversalMerchantTranId $parameters
     * @return \StructType\ReversalMerchantTranIdResponse|bool
     */
    public function reversalMerchantTranId(\StructType\ReversalMerchantTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reversalMerchantTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named reversalIssuerTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReversalIssuerTranId $parameters
     * @return \StructType\ReversalIssuerTranIdResponse|bool
     */
    public function reversalIssuerTranId(\StructType\ReversalIssuerTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reversalIssuerTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReversalIssuerTranIdResponse|\StructType\ReversalMerchantTranIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
