<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transactionResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:transactionResult
 * @subpackage Structs
 */
class TransactionResult extends AbstractStructBase
{
    /**
     * The authorizationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $authorizationCode;
    /**
     * The cafeteriaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cafeteriaCode;
    /**
     * The issuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuerTranId;
    /**
     * The merchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $merchantTranId;
    /**
     * The responseCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $responseCode;
    /**
     * The responseMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $responseMessage;
    /**
     * The reversalIssuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reversalIssuerTranId;
    /**
     * The transactionDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transactionDatetime;
    /**
     * The transactionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $transactionStatus;
    /**
     * Constructor method for transactionResult
     * @uses TransactionResult::setAuthorizationCode()
     * @uses TransactionResult::setCafeteriaCode()
     * @uses TransactionResult::setIssuerTranId()
     * @uses TransactionResult::setMerchantTranId()
     * @uses TransactionResult::setResponseCode()
     * @uses TransactionResult::setResponseMessage()
     * @uses TransactionResult::setReversalIssuerTranId()
     * @uses TransactionResult::setTransactionDatetime()
     * @uses TransactionResult::setTransactionStatus()
     * @param string $authorizationCode
     * @param string $cafeteriaCode
     * @param int $issuerTranId
     * @param string $merchantTranId
     * @param string $responseCode
     * @param string $responseMessage
     * @param int $reversalIssuerTranId
     * @param string $transactionDatetime
     * @param string $transactionStatus
     */
    public function __construct($authorizationCode = null, $cafeteriaCode = null, $issuerTranId = null, $merchantTranId = null, $responseCode = null, $responseMessage = null, $reversalIssuerTranId = null, $transactionDatetime = null, $transactionStatus = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setCafeteriaCode($cafeteriaCode)
            ->setIssuerTranId($issuerTranId)
            ->setMerchantTranId($merchantTranId)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage)
            ->setReversalIssuerTranId($reversalIssuerTranId)
            ->setTransactionDatetime($transactionDatetime)
            ->setTransactionStatus($transactionStatus);
    }
    /**
     * Get authorizationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return isset($this->authorizationCode) ? $this->authorizationCode : null;
    }
    /**
     * Set authorizationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationCode
     * @return \StructType\TransactionResult
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        if (is_null($authorizationCode) || (is_array($authorizationCode) && empty($authorizationCode))) {
            unset($this->authorizationCode);
        } else {
            $this->authorizationCode = $authorizationCode;
        }
        return $this;
    }
    /**
     * Get cafeteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return isset($this->cafeteriaCode) ? $this->cafeteriaCode : null;
    }
    /**
     * Set cafeteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cafeteriaCode
     * @return \StructType\TransactionResult
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        if (is_null($cafeteriaCode) || (is_array($cafeteriaCode) && empty($cafeteriaCode))) {
            unset($this->cafeteriaCode);
        } else {
            $this->cafeteriaCode = $cafeteriaCode;
        }
        return $this;
    }
    /**
     * Get issuerTranId value
     * @return int|null
     */
    public function getIssuerTranId()
    {
        return $this->issuerTranId;
    }
    /**
     * Set issuerTranId value
     * @param int $issuerTranId
     * @return \StructType\TransactionResult
     */
    public function setIssuerTranId($issuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTranId) && !(is_int($issuerTranId) || ctype_digit($issuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTranId, true), gettype($issuerTranId)), __LINE__);
        }
        $this->issuerTranId = $issuerTranId;
        return $this;
    }
    /**
     * Get merchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return isset($this->merchantTranId) ? $this->merchantTranId : null;
    }
    /**
     * Set merchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantTranId
     * @return \StructType\TransactionResult
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        if (is_null($merchantTranId) || (is_array($merchantTranId) && empty($merchantTranId))) {
            unset($this->merchantTranId);
        } else {
            $this->merchantTranId = $merchantTranId;
        }
        return $this;
    }
    /**
     * Get responseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->responseCode) ? $this->responseCode : null;
    }
    /**
     * Set responseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\TransactionResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->responseCode);
        } else {
            $this->responseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get responseMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseMessage()
    {
        return isset($this->responseMessage) ? $this->responseMessage : null;
    }
    /**
     * Set responseMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseMessage
     * @return \StructType\TransactionResult
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        if (is_null($responseMessage) || (is_array($responseMessage) && empty($responseMessage))) {
            unset($this->responseMessage);
        } else {
            $this->responseMessage = $responseMessage;
        }
        return $this;
    }
    /**
     * Get reversalIssuerTranId value
     * @return int|null
     */
    public function getReversalIssuerTranId()
    {
        return $this->reversalIssuerTranId;
    }
    /**
     * Set reversalIssuerTranId value
     * @param int $reversalIssuerTranId
     * @return \StructType\TransactionResult
     */
    public function setReversalIssuerTranId($reversalIssuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($reversalIssuerTranId) && !(is_int($reversalIssuerTranId) || ctype_digit($reversalIssuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reversalIssuerTranId, true), gettype($reversalIssuerTranId)), __LINE__);
        }
        $this->reversalIssuerTranId = $reversalIssuerTranId;
        return $this;
    }
    /**
     * Get transactionDatetime value
     * @return string|null
     */
    public function getTransactionDatetime()
    {
        return $this->transactionDatetime;
    }
    /**
     * Set transactionDatetime value
     * @param string $transactionDatetime
     * @return \StructType\TransactionResult
     */
    public function setTransactionDatetime($transactionDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDatetime) && !is_string($transactionDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDatetime, true), gettype($transactionDatetime)), __LINE__);
        }
        $this->transactionDatetime = $transactionDatetime;
        return $this;
    }
    /**
     * Get transactionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return isset($this->transactionStatus) ? $this->transactionStatus : null;
    }
    /**
     * Set transactionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionStatus
     * @return \StructType\TransactionResult
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatus) && !is_string($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatus, true), gettype($transactionStatus)), __LINE__);
        }
        if (is_null($transactionStatus) || (is_array($transactionStatus) && empty($transactionStatus))) {
            unset($this->transactionStatus);
        } else {
            $this->transactionStatus = $transactionStatus;
        }
        return $this;
    }
}
