<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reversalIssuerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:reversalIssuerRequest
 * @subpackage Structs
 */
class ReversalIssuerRequest extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amount;
    /**
     * The issuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuerMerchantId;
    /**
     * The issuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuerTranId;
    /**
     * The terminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminalId;
    /**
     * Constructor method for reversalIssuerRequest
     * @uses ReversalIssuerRequest::setAmount()
     * @uses ReversalIssuerRequest::setIssuerMerchantId()
     * @uses ReversalIssuerRequest::setIssuerTranId()
     * @uses ReversalIssuerRequest::setTerminalId()
     * @param int $amount
     * @param int $issuerMerchantId
     * @param int $issuerTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $issuerMerchantId = null, $issuerTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setIssuerTranId($issuerTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\ReversalIssuerRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get issuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->issuerMerchantId;
    }
    /**
     * Set issuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\ReversalIssuerRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->issuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get issuerTranId value
     * @return int|null
     */
    public function getIssuerTranId()
    {
        return $this->issuerTranId;
    }
    /**
     * Set issuerTranId value
     * @param int $issuerTranId
     * @return \StructType\ReversalIssuerRequest
     */
    public function setIssuerTranId($issuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTranId) && !(is_int($issuerTranId) || ctype_digit($issuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTranId, true), gettype($issuerTranId)), __LINE__);
        }
        $this->issuerTranId = $issuerTranId;
        return $this;
    }
    /**
     * Get terminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->terminalId) ? $this->terminalId : null;
    }
    /**
     * Set terminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\ReversalIssuerRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->terminalId);
        } else {
            $this->terminalId = $terminalId;
        }
        return $this;
    }
}
