<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for purchaseMobilePOSRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:purchaseMobilePOSRequest
 * @subpackage Structs
 */
class PurchaseMobilePOSRequest extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $amount;
    /**
     * The cafeteriaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cafeteriaCode;
    /**
     * The cardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cardNumber;
    /**
     * The cvv1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cvv1;
    /**
     * The issuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $issuerMerchantId;
    /**
     * The merchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $merchantTranId;
    /**
     * The terminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminalId;
    /**
     * Constructor method for purchaseMobilePOSRequest
     * @uses PurchaseMobilePOSRequest::setAmount()
     * @uses PurchaseMobilePOSRequest::setCafeteriaCode()
     * @uses PurchaseMobilePOSRequest::setCardNumber()
     * @uses PurchaseMobilePOSRequest::setCvv1()
     * @uses PurchaseMobilePOSRequest::setIssuerMerchantId()
     * @uses PurchaseMobilePOSRequest::setMerchantTranId()
     * @uses PurchaseMobilePOSRequest::setTerminalId()
     * @param int $amount
     * @param string $cafeteriaCode
     * @param string $cardNumber
     * @param string $cvv1
     * @param int $issuerMerchantId
     * @param string $merchantTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $cafeteriaCode = null, $cardNumber = null, $cvv1 = null, $issuerMerchantId = null, $merchantTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setCafeteriaCode($cafeteriaCode)
            ->setCardNumber($cardNumber)
            ->setCvv1($cvv1)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setMerchantTranId($merchantTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAmount()
    {
        return isset($this->amount) ? $this->amount : null;
    }
    /**
     * Set amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $amount
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->amount);
        } else {
            $this->amount = $amount;
        }
        return $this;
    }
    /**
     * Get cafeteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return isset($this->cafeteriaCode) ? $this->cafeteriaCode : null;
    }
    /**
     * Set cafeteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cafeteriaCode
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        if (is_null($cafeteriaCode) || (is_array($cafeteriaCode) && empty($cafeteriaCode))) {
            unset($this->cafeteriaCode);
        } else {
            $this->cafeteriaCode = $cafeteriaCode;
        }
        return $this;
    }
    /**
     * Get cardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->cardNumber) ? $this->cardNumber : null;
    }
    /**
     * Set cardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->cardNumber);
        } else {
            $this->cardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get cvv1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCvv1()
    {
        return isset($this->cvv1) ? $this->cvv1 : null;
    }
    /**
     * Set cvv1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cvv1
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setCvv1($cvv1 = null)
    {
        // validation for constraint: string
        if (!is_null($cvv1) && !is_string($cvv1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cvv1, true), gettype($cvv1)), __LINE__);
        }
        if (is_null($cvv1) || (is_array($cvv1) && empty($cvv1))) {
            unset($this->cvv1);
        } else {
            $this->cvv1 = $cvv1;
        }
        return $this;
    }
    /**
     * Get issuerMerchantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return isset($this->issuerMerchantId) ? $this->issuerMerchantId : null;
    }
    /**
     * Set issuerMerchantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerMerchantId
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        if (is_null($issuerMerchantId) || (is_array($issuerMerchantId) && empty($issuerMerchantId))) {
            unset($this->issuerMerchantId);
        } else {
            $this->issuerMerchantId = $issuerMerchantId;
        }
        return $this;
    }
    /**
     * Get merchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return isset($this->merchantTranId) ? $this->merchantTranId : null;
    }
    /**
     * Set merchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantTranId
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        if (is_null($merchantTranId) || (is_array($merchantTranId) && empty($merchantTranId))) {
            unset($this->merchantTranId);
        } else {
            $this->merchantTranId = $merchantTranId;
        }
        return $this;
    }
    /**
     * Get terminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->terminalId) ? $this->terminalId : null;
    }
    /**
     * Set terminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\PurchaseMobilePOSRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->terminalId);
        } else {
            $this->terminalId = $terminalId;
        }
        return $this;
    }
}
