<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionResult
 * @subpackage Structs
 */
class TransactionResult extends AbstractStructBase
{
    /**
     * The authorizationCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $authorizationCode;
    /**
     * The cafeteriaCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cafeteriaCode;
    /**
     * The issuerTranId
     * @var int
     */
    public $issuerTranId;
    /**
     * The merchantTranId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $merchantTranId;
    /**
     * The responseCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $responseCode;
    /**
     * The responseMessage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $responseMessage;
    /**
     * The reversalIssuerTranId
     * @var int
     */
    public $reversalIssuerTranId;
    /**
     * The transactionDatetime
     * @var string
     */
    public $transactionDatetime;
    /**
     * The transactionStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $transactionStatus;
    /**
     * Constructor method for TransactionResult
     * @uses TransactionResult::setAuthorizationCode()
     * @uses TransactionResult::setCafeteriaCode()
     * @uses TransactionResult::setIssuerTranId()
     * @uses TransactionResult::setMerchantTranId()
     * @uses TransactionResult::setResponseCode()
     * @uses TransactionResult::setResponseMessage()
     * @uses TransactionResult::setReversalIssuerTranId()
     * @uses TransactionResult::setTransactionDatetime()
     * @uses TransactionResult::setTransactionStatus()
     * @param string $authorizationCode
     * @param string $cafeteriaCode
     * @param int $issuerTranId
     * @param string $merchantTranId
     * @param string $responseCode
     * @param string $responseMessage
     * @param int $reversalIssuerTranId
     * @param string $transactionDatetime
     * @param string $transactionStatus
     */
    public function __construct($authorizationCode = null, $cafeteriaCode = null, $issuerTranId = null, $merchantTranId = null, $responseCode = null, $responseMessage = null, $reversalIssuerTranId = null, $transactionDatetime = null, $transactionStatus = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setCafeteriaCode($cafeteriaCode)
            ->setIssuerTranId($issuerTranId)
            ->setMerchantTranId($merchantTranId)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage)
            ->setReversalIssuerTranId($reversalIssuerTranId)
            ->setTransactionDatetime($transactionDatetime)
            ->setTransactionStatus($transactionStatus);
    }
    /**
     * Get authorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->authorizationCode;
    }
    /**
     * Set authorizationCode value
     * @param string $authorizationCode
     * @return \StructType\TransactionResult
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->authorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get cafeteriaCode value
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return $this->cafeteriaCode;
    }
    /**
     * Set cafeteriaCode value
     * @param string $cafeteriaCode
     * @return \StructType\TransactionResult
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        $this->cafeteriaCode = $cafeteriaCode;
        return $this;
    }
    /**
     * Get issuerTranId value
     * @return int|null
     */
    public function getIssuerTranId()
    {
        return $this->issuerTranId;
    }
    /**
     * Set issuerTranId value
     * @param int $issuerTranId
     * @return \StructType\TransactionResult
     */
    public function setIssuerTranId($issuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTranId) && !(is_int($issuerTranId) || ctype_digit($issuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTranId, true), gettype($issuerTranId)), __LINE__);
        }
        $this->issuerTranId = $issuerTranId;
        return $this;
    }
    /**
     * Get merchantTranId value
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return $this->merchantTranId;
    }
    /**
     * Set merchantTranId value
     * @param string $merchantTranId
     * @return \StructType\TransactionResult
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        $this->merchantTranId = $merchantTranId;
        return $this;
    }
    /**
     * Get responseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param string $responseCode
     * @return \StructType\TransactionResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Get responseMessage value
     * @return string|null
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }
    /**
     * Set responseMessage value
     * @param string $responseMessage
     * @return \StructType\TransactionResult
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        $this->responseMessage = $responseMessage;
        return $this;
    }
    /**
     * Get reversalIssuerTranId value
     * @return int|null
     */
    public function getReversalIssuerTranId()
    {
        return $this->reversalIssuerTranId;
    }
    /**
     * Set reversalIssuerTranId value
     * @param int $reversalIssuerTranId
     * @return \StructType\TransactionResult
     */
    public function setReversalIssuerTranId($reversalIssuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($reversalIssuerTranId) && !(is_int($reversalIssuerTranId) || ctype_digit($reversalIssuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reversalIssuerTranId, true), gettype($reversalIssuerTranId)), __LINE__);
        }
        $this->reversalIssuerTranId = $reversalIssuerTranId;
        return $this;
    }
    /**
     * Get transactionDatetime value
     * @return string|null
     */
    public function getTransactionDatetime()
    {
        return $this->transactionDatetime;
    }
    /**
     * Set transactionDatetime value
     * @param string $transactionDatetime
     * @return \StructType\TransactionResult
     */
    public function setTransactionDatetime($transactionDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDatetime) && !is_string($transactionDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDatetime, true), gettype($transactionDatetime)), __LINE__);
        }
        $this->transactionDatetime = $transactionDatetime;
        return $this;
    }
    /**
     * Get transactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->transactionStatus;
    }
    /**
     * Set transactionStatus value
     * @param string $transactionStatus
     * @return \StructType\TransactionResult
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatus) && !is_string($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatus, true), gettype($transactionStatus)), __LINE__);
        }
        $this->transactionStatus = $transactionStatus;
        return $this;
    }
}
