<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseWebshopRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PurchaseWebshopRequest
 * @subpackage Structs
 */
class PurchaseWebshopRequest extends AbstractStructBase
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The cafeteriaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cafeteriaCode;
    /**
     * The cardnumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardnumber;
    /**
     * The cvv2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cvv2;
    /**
     * The issuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuerMerchantId;
    /**
     * The merchantTranId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $merchantTranId;
    /**
     * The terminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminalId;
    /**
     * Constructor method for PurchaseWebshopRequest
     * @uses PurchaseWebshopRequest::setAmount()
     * @uses PurchaseWebshopRequest::setCafeteriaCode()
     * @uses PurchaseWebshopRequest::setCardnumber()
     * @uses PurchaseWebshopRequest::setCvv2()
     * @uses PurchaseWebshopRequest::setIssuerMerchantId()
     * @uses PurchaseWebshopRequest::setMerchantTranId()
     * @uses PurchaseWebshopRequest::setTerminalId()
     * @param int $amount
     * @param string $cafeteriaCode
     * @param string $cardnumber
     * @param string $cvv2
     * @param int $issuerMerchantId
     * @param string $merchantTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $cafeteriaCode = null, $cardnumber = null, $cvv2 = null, $issuerMerchantId = null, $merchantTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setCafeteriaCode($cafeteriaCode)
            ->setCardnumber($cardnumber)
            ->setCvv2($cvv2)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setMerchantTranId($merchantTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get cafeteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return isset($this->cafeteriaCode) ? $this->cafeteriaCode : null;
    }
    /**
     * Set cafeteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cafeteriaCode
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        if (is_null($cafeteriaCode) || (is_array($cafeteriaCode) && empty($cafeteriaCode))) {
            unset($this->cafeteriaCode);
        } else {
            $this->cafeteriaCode = $cafeteriaCode;
        }
        return $this;
    }
    /**
     * Get cardnumber value
     * @return string|null
     */
    public function getCardnumber()
    {
        return $this->cardnumber;
    }
    /**
     * Set cardnumber value
     * @param string $cardnumber
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCardnumber($cardnumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardnumber) && !is_string($cardnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardnumber, true), gettype($cardnumber)), __LINE__);
        }
        $this->cardnumber = $cardnumber;
        return $this;
    }
    /**
     * Get cvv2 value
     * @return string|null
     */
    public function getCvv2()
    {
        return $this->cvv2;
    }
    /**
     * Set cvv2 value
     * @param string $cvv2
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCvv2($cvv2 = null)
    {
        // validation for constraint: string
        if (!is_null($cvv2) && !is_string($cvv2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cvv2, true), gettype($cvv2)), __LINE__);
        }
        $this->cvv2 = $cvv2;
        return $this;
    }
    /**
     * Get issuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->issuerMerchantId;
    }
    /**
     * Set issuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->issuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get merchantTranId value
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return $this->merchantTranId;
    }
    /**
     * Set merchantTranId value
     * @param string $merchantTranId
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        $this->merchantTranId = $merchantTranId;
        return $this;
    }
    /**
     * Get terminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->terminalId) ? $this->terminalId : null;
    }
    /**
     * Set terminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->terminalId);
        } else {
            $this->terminalId = $terminalId;
        }
        return $this;
    }
}
