<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionResult
 * @subpackage Structs
 */
class TransactionResult extends AbstractStructBase
{
    /**
     * The authorization_code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $authorization_code;
    /**
     * The cafeteria_code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cafeteria_code;
    /**
     * The issuertran_id
     * @var int
     */
    public $issuertran_id;
    /**
     * The merchanttran_id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $merchanttran_id;
    /**
     * The response_code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $response_code;
    /**
     * The response_message
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $response_message;
    /**
     * The reversal_issuertran_id
     * @var int
     */
    public $reversal_issuertran_id;
    /**
     * The transaction_datetime
     * @var string
     */
    public $transaction_datetime;
    /**
     * The transaction_status
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $transaction_status;
    /**
     * Constructor method for TransactionResult
     * @uses TransactionResult::setAuthorization_code()
     * @uses TransactionResult::setCafeteria_code()
     * @uses TransactionResult::setIssuertran_id()
     * @uses TransactionResult::setMerchanttran_id()
     * @uses TransactionResult::setResponse_code()
     * @uses TransactionResult::setResponse_message()
     * @uses TransactionResult::setReversal_issuertran_id()
     * @uses TransactionResult::setTransaction_datetime()
     * @uses TransactionResult::setTransaction_status()
     * @param string $authorization_code
     * @param string $cafeteria_code
     * @param int $issuertran_id
     * @param string $merchanttran_id
     * @param string $response_code
     * @param string $response_message
     * @param int $reversal_issuertran_id
     * @param string $transaction_datetime
     * @param string $transaction_status
     */
    public function __construct($authorization_code = null, $cafeteria_code = null, $issuertran_id = null, $merchanttran_id = null, $response_code = null, $response_message = null, $reversal_issuertran_id = null, $transaction_datetime = null, $transaction_status = null)
    {
        $this
            ->setAuthorization_code($authorization_code)
            ->setCafeteria_code($cafeteria_code)
            ->setIssuertran_id($issuertran_id)
            ->setMerchanttran_id($merchanttran_id)
            ->setResponse_code($response_code)
            ->setResponse_message($response_message)
            ->setReversal_issuertran_id($reversal_issuertran_id)
            ->setTransaction_datetime($transaction_datetime)
            ->setTransaction_status($transaction_status);
    }
    /**
     * Get authorization_code value
     * @return string|null
     */
    public function getAuthorization_code()
    {
        return $this->authorization_code;
    }
    /**
     * Set authorization_code value
     * @param string $authorization_code
     * @return \StructType\TransactionResult
     */
    public function setAuthorization_code($authorization_code = null)
    {
        // validation for constraint: string
        if (!is_null($authorization_code) && !is_string($authorization_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorization_code, true), gettype($authorization_code)), __LINE__);
        }
        $this->authorization_code = $authorization_code;
        return $this;
    }
    /**
     * Get cafeteria_code value
     * @return string|null
     */
    public function getCafeteria_code()
    {
        return $this->cafeteria_code;
    }
    /**
     * Set cafeteria_code value
     * @param string $cafeteria_code
     * @return \StructType\TransactionResult
     */
    public function setCafeteria_code($cafeteria_code = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteria_code) && !is_string($cafeteria_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteria_code, true), gettype($cafeteria_code)), __LINE__);
        }
        $this->cafeteria_code = $cafeteria_code;
        return $this;
    }
    /**
     * Get issuertran_id value
     * @return int|null
     */
    public function getIssuertran_id()
    {
        return $this->issuertran_id;
    }
    /**
     * Set issuertran_id value
     * @param int $issuertran_id
     * @return \StructType\TransactionResult
     */
    public function setIssuertran_id($issuertran_id = null)
    {
        // validation for constraint: int
        if (!is_null($issuertran_id) && !(is_int($issuertran_id) || ctype_digit($issuertran_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuertran_id, true), gettype($issuertran_id)), __LINE__);
        }
        $this->issuertran_id = $issuertran_id;
        return $this;
    }
    /**
     * Get merchanttran_id value
     * @return string|null
     */
    public function getMerchanttran_id()
    {
        return $this->merchanttran_id;
    }
    /**
     * Set merchanttran_id value
     * @param string $merchanttran_id
     * @return \StructType\TransactionResult
     */
    public function setMerchanttran_id($merchanttran_id = null)
    {
        // validation for constraint: string
        if (!is_null($merchanttran_id) && !is_string($merchanttran_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchanttran_id, true), gettype($merchanttran_id)), __LINE__);
        }
        $this->merchanttran_id = $merchanttran_id;
        return $this;
    }
    /**
     * Get response_code value
     * @return string|null
     */
    public function getResponse_code()
    {
        return $this->response_code;
    }
    /**
     * Set response_code value
     * @param string $response_code
     * @return \StructType\TransactionResult
     */
    public function setResponse_code($response_code = null)
    {
        // validation for constraint: string
        if (!is_null($response_code) && !is_string($response_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_code, true), gettype($response_code)), __LINE__);
        }
        $this->response_code = $response_code;
        return $this;
    }
    /**
     * Get response_message value
     * @return string|null
     */
    public function getResponse_message()
    {
        return $this->response_message;
    }
    /**
     * Set response_message value
     * @param string $response_message
     * @return \StructType\TransactionResult
     */
    public function setResponse_message($response_message = null)
    {
        // validation for constraint: string
        if (!is_null($response_message) && !is_string($response_message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_message, true), gettype($response_message)), __LINE__);
        }
        $this->response_message = $response_message;
        return $this;
    }
    /**
     * Get reversal_issuertran_id value
     * @return int|null
     */
    public function getReversal_issuertran_id()
    {
        return $this->reversal_issuertran_id;
    }
    /**
     * Set reversal_issuertran_id value
     * @param int $reversal_issuertran_id
     * @return \StructType\TransactionResult
     */
    public function setReversal_issuertran_id($reversal_issuertran_id = null)
    {
        // validation for constraint: int
        if (!is_null($reversal_issuertran_id) && !(is_int($reversal_issuertran_id) || ctype_digit($reversal_issuertran_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reversal_issuertran_id, true), gettype($reversal_issuertran_id)), __LINE__);
        }
        $this->reversal_issuertran_id = $reversal_issuertran_id;
        return $this;
    }
    /**
     * Get transaction_datetime value
     * @return string|null
     */
    public function getTransaction_datetime()
    {
        return $this->transaction_datetime;
    }
    /**
     * Set transaction_datetime value
     * @param string $transaction_datetime
     * @return \StructType\TransactionResult
     */
    public function setTransaction_datetime($transaction_datetime = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_datetime) && !is_string($transaction_datetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_datetime, true), gettype($transaction_datetime)), __LINE__);
        }
        $this->transaction_datetime = $transaction_datetime;
        return $this;
    }
    /**
     * Get transaction_status value
     * @return string|null
     */
    public function getTransaction_status()
    {
        return $this->transaction_status;
    }
    /**
     * Set transaction_status value
     * @param string $transaction_status
     * @return \StructType\TransactionResult
     */
    public function setTransaction_status($transaction_status = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_status) && !is_string($transaction_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_status, true), gettype($transaction_status)), __LINE__);
        }
        $this->transaction_status = $transaction_status;
        return $this;
    }
}
