<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseWebshopRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PurchaseWebshopRequest
 * @subpackage Structs
 */
class PurchaseWebshopRequest extends AbstractStructBase
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The cafeteria_code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cafeteria_code;
    /**
     * The cardnumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cardnumber;
    /**
     * The cvv2
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cvv2;
    /**
     * The issuermerchant_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuermerchant_id;
    /**
     * The merchanttran_id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $merchanttran_id;
    /**
     * The terminal_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminal_id;
    /**
     * Constructor method for PurchaseWebshopRequest
     * @uses PurchaseWebshopRequest::setAmount()
     * @uses PurchaseWebshopRequest::setCafeteria_code()
     * @uses PurchaseWebshopRequest::setCardnumber()
     * @uses PurchaseWebshopRequest::setCvv2()
     * @uses PurchaseWebshopRequest::setIssuermerchant_id()
     * @uses PurchaseWebshopRequest::setMerchanttran_id()
     * @uses PurchaseWebshopRequest::setTerminal_id()
     * @param int $amount
     * @param string $cafeteria_code
     * @param string $cardnumber
     * @param string $cvv2
     * @param int $issuermerchant_id
     * @param string $merchanttran_id
     * @param string $terminal_id
     */
    public function __construct($amount = null, $cafeteria_code = null, $cardnumber = null, $cvv2 = null, $issuermerchant_id = null, $merchanttran_id = null, $terminal_id = null)
    {
        $this
            ->setAmount($amount)
            ->setCafeteria_code($cafeteria_code)
            ->setCardnumber($cardnumber)
            ->setCvv2($cvv2)
            ->setIssuermerchant_id($issuermerchant_id)
            ->setMerchanttran_id($merchanttran_id)
            ->setTerminal_id($terminal_id);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get cafeteria_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCafeteria_code()
    {
        return isset($this->cafeteria_code) ? $this->cafeteria_code : null;
    }
    /**
     * Set cafeteria_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cafeteria_code
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCafeteria_code($cafeteria_code = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteria_code) && !is_string($cafeteria_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteria_code, true), gettype($cafeteria_code)), __LINE__);
        }
        if (is_null($cafeteria_code) || (is_array($cafeteria_code) && empty($cafeteria_code))) {
            unset($this->cafeteria_code);
        } else {
            $this->cafeteria_code = $cafeteria_code;
        }
        return $this;
    }
    /**
     * Get cardnumber value
     * @return string|null
     */
    public function getCardnumber()
    {
        return $this->cardnumber;
    }
    /**
     * Set cardnumber value
     * @param string $cardnumber
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCardnumber($cardnumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardnumber) && !is_string($cardnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardnumber, true), gettype($cardnumber)), __LINE__);
        }
        $this->cardnumber = $cardnumber;
        return $this;
    }
    /**
     * Get cvv2 value
     * @return string|null
     */
    public function getCvv2()
    {
        return $this->cvv2;
    }
    /**
     * Set cvv2 value
     * @param string $cvv2
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCvv2($cvv2 = null)
    {
        // validation for constraint: string
        if (!is_null($cvv2) && !is_string($cvv2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cvv2, true), gettype($cvv2)), __LINE__);
        }
        $this->cvv2 = $cvv2;
        return $this;
    }
    /**
     * Get issuermerchant_id value
     * @return int|null
     */
    public function getIssuermerchant_id()
    {
        return $this->issuermerchant_id;
    }
    /**
     * Set issuermerchant_id value
     * @param int $issuermerchant_id
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setIssuermerchant_id($issuermerchant_id = null)
    {
        // validation for constraint: int
        if (!is_null($issuermerchant_id) && !(is_int($issuermerchant_id) || ctype_digit($issuermerchant_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuermerchant_id, true), gettype($issuermerchant_id)), __LINE__);
        }
        $this->issuermerchant_id = $issuermerchant_id;
        return $this;
    }
    /**
     * Get merchanttran_id value
     * @return string|null
     */
    public function getMerchanttran_id()
    {
        return $this->merchanttran_id;
    }
    /**
     * Set merchanttran_id value
     * @param string $merchanttran_id
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setMerchanttran_id($merchanttran_id = null)
    {
        // validation for constraint: string
        if (!is_null($merchanttran_id) && !is_string($merchanttran_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchanttran_id, true), gettype($merchanttran_id)), __LINE__);
        }
        $this->merchanttran_id = $merchanttran_id;
        return $this;
    }
    /**
     * Get terminal_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminal_id()
    {
        return isset($this->terminal_id) ? $this->terminal_id : null;
    }
    /**
     * Set terminal_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminal_id
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setTerminal_id($terminal_id = null)
    {
        // validation for constraint: string
        if (!is_null($terminal_id) && !is_string($terminal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal_id, true), gettype($terminal_id)), __LINE__);
        }
        if (is_null($terminal_id) || (is_array($terminal_id) && empty($terminal_id))) {
            unset($this->terminal_id);
        } else {
            $this->terminal_id = $terminal_id;
        }
        return $this;
    }
}
