<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPurchaseWebshopRequest ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPurchaseWebshopRequest
 * @subpackage Arrays
 */
class ArrayOfPurchaseWebshopRequest extends AbstractStructArrayBase
{
    /**
     * The PurchaseWebshopRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PurchaseWebshopRequest[]
     */
    public $PurchaseWebshopRequest;
    /**
     * Constructor method for ArrayOfPurchaseWebshopRequest
     * @uses ArrayOfPurchaseWebshopRequest::setPurchaseWebshopRequest()
     * @param \StructType\PurchaseWebshopRequest[] $purchaseWebshopRequest
     */
    public function __construct(array $purchaseWebshopRequest = array())
    {
        $this
            ->setPurchaseWebshopRequest($purchaseWebshopRequest);
    }
    /**
     * Get PurchaseWebshopRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PurchaseWebshopRequest[]|null
     */
    public function getPurchaseWebshopRequest()
    {
        return isset($this->PurchaseWebshopRequest) ? $this->PurchaseWebshopRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseWebshopRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseWebshopRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseWebshopRequestForArrayConstraintsFromSetPurchaseWebshopRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPurchaseWebshopRequestPurchaseWebshopRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfPurchaseWebshopRequestPurchaseWebshopRequestItem instanceof \StructType\PurchaseWebshopRequest) {
                $invalidValues[] = is_object($arrayOfPurchaseWebshopRequestPurchaseWebshopRequestItem) ? get_class($arrayOfPurchaseWebshopRequestPurchaseWebshopRequestItem) : sprintf('%s(%s)', gettype($arrayOfPurchaseWebshopRequestPurchaseWebshopRequestItem), var_export($arrayOfPurchaseWebshopRequestPurchaseWebshopRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseWebshopRequest property can only contain items of type \StructType\PurchaseWebshopRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseWebshopRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseWebshopRequest[] $purchaseWebshopRequest
     * @return \ArrayType\ArrayOfPurchaseWebshopRequest
     */
    public function setPurchaseWebshopRequest(array $purchaseWebshopRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseWebshopRequestArrayErrorMessage = self::validatePurchaseWebshopRequestForArrayConstraintsFromSetPurchaseWebshopRequest($purchaseWebshopRequest))) {
            throw new \InvalidArgumentException($purchaseWebshopRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseWebshopRequest) || (is_array($purchaseWebshopRequest) && empty($purchaseWebshopRequest))) {
            unset($this->PurchaseWebshopRequest);
        } else {
            $this->PurchaseWebshopRequest = $purchaseWebshopRequest;
        }
        return $this;
    }
    /**
     * Add item to PurchaseWebshopRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseWebshopRequest $item
     * @return \ArrayType\ArrayOfPurchaseWebshopRequest
     */
    public function addToPurchaseWebshopRequest(\StructType\PurchaseWebshopRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchaseWebshopRequest) {
            throw new \InvalidArgumentException(sprintf('The PurchaseWebshopRequest property can only contain items of type \StructType\PurchaseWebshopRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseWebshopRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PurchaseWebshopRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PurchaseWebshopRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PurchaseWebshopRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PurchaseWebshopRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PurchaseWebshopRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PurchaseWebshopRequest
     */
    public function getAttributeName()
    {
        return 'PurchaseWebshopRequest';
    }
}
