<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Purchasewebshop ServiceType
 * @subpackage Services
 */
class Purchasewebshop extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named purchase_webshop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Purchase_webshop $parameters
     * @return \StructType\Purchase_webshopResponse|bool
     */
    public function purchase_webshop(\StructType\Purchase_webshop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->purchase_webshop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Purchase_webshopResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
