<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversalIssuerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReversalIssuerRequest
 * @subpackage Structs
 */
class ReversalIssuerRequest extends AbstractStructBase
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The issuermerchant_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuermerchant_id;
    /**
     * The issuertran_id
     * @var int
     */
    public $issuertran_id;
    /**
     * The terminal_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminal_id;
    /**
     * Constructor method for ReversalIssuerRequest
     * @uses ReversalIssuerRequest::setAmount()
     * @uses ReversalIssuerRequest::setIssuermerchant_id()
     * @uses ReversalIssuerRequest::setIssuertran_id()
     * @uses ReversalIssuerRequest::setTerminal_id()
     * @param int $amount
     * @param int $issuermerchant_id
     * @param int $issuertran_id
     * @param string $terminal_id
     */
    public function __construct($amount = null, $issuermerchant_id = null, $issuertran_id = null, $terminal_id = null)
    {
        $this
            ->setAmount($amount)
            ->setIssuermerchant_id($issuermerchant_id)
            ->setIssuertran_id($issuertran_id)
            ->setTerminal_id($terminal_id);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\ReversalIssuerRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get issuermerchant_id value
     * @return int|null
     */
    public function getIssuermerchant_id()
    {
        return $this->issuermerchant_id;
    }
    /**
     * Set issuermerchant_id value
     * @param int $issuermerchant_id
     * @return \StructType\ReversalIssuerRequest
     */
    public function setIssuermerchant_id($issuermerchant_id = null)
    {
        // validation for constraint: int
        if (!is_null($issuermerchant_id) && !(is_int($issuermerchant_id) || ctype_digit($issuermerchant_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuermerchant_id, true), gettype($issuermerchant_id)), __LINE__);
        }
        $this->issuermerchant_id = $issuermerchant_id;
        return $this;
    }
    /**
     * Get issuertran_id value
     * @return int|null
     */
    public function getIssuertran_id()
    {
        return $this->issuertran_id;
    }
    /**
     * Set issuertran_id value
     * @param int $issuertran_id
     * @return \StructType\ReversalIssuerRequest
     */
    public function setIssuertran_id($issuertran_id = null)
    {
        // validation for constraint: int
        if (!is_null($issuertran_id) && !(is_int($issuertran_id) || ctype_digit($issuertran_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuertran_id, true), gettype($issuertran_id)), __LINE__);
        }
        $this->issuertran_id = $issuertran_id;
        return $this;
    }
    /**
     * Get terminal_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminal_id()
    {
        return isset($this->terminal_id) ? $this->terminal_id : null;
    }
    /**
     * Set terminal_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminal_id
     * @return \StructType\ReversalIssuerRequest
     */
    public function setTerminal_id($terminal_id = null)
    {
        // validation for constraint: string
        if (!is_null($terminal_id) && !is_string($terminal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal_id, true), gettype($terminal_id)), __LINE__);
        }
        if (is_null($terminal_id) || (is_array($terminal_id) && empty($terminal_id))) {
            unset($this->terminal_id);
        } else {
            $this->terminal_id = $terminal_id;
        }
        return $this;
    }
}
