<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetResponseMerchantRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetResponseMerchantRequest
 * @subpackage Structs
 */
class GetResponseMerchantRequest extends AbstractStructBase
{
    /**
     * The amount
     * @var int
     */
    public $amount;
    /**
     * The issuermerchant_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $issuermerchant_id;
    /**
     * The merchanttran_id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $merchanttran_id;
    /**
     * The terminal_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $terminal_id;
    /**
     * Constructor method for GetResponseMerchantRequest
     * @uses GetResponseMerchantRequest::setAmount()
     * @uses GetResponseMerchantRequest::setIssuermerchant_id()
     * @uses GetResponseMerchantRequest::setMerchanttran_id()
     * @uses GetResponseMerchantRequest::setTerminal_id()
     * @param int $amount
     * @param int $issuermerchant_id
     * @param string $merchanttran_id
     * @param string $terminal_id
     */
    public function __construct($amount = null, $issuermerchant_id = null, $merchanttran_id = null, $terminal_id = null)
    {
        $this
            ->setAmount($amount)
            ->setIssuermerchant_id($issuermerchant_id)
            ->setMerchanttran_id($merchanttran_id)
            ->setTerminal_id($terminal_id);
    }
    /**
     * Get amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get issuermerchant_id value
     * @return int|null
     */
    public function getIssuermerchant_id()
    {
        return $this->issuermerchant_id;
    }
    /**
     * Set issuermerchant_id value
     * @param int $issuermerchant_id
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setIssuermerchant_id($issuermerchant_id = null)
    {
        // validation for constraint: int
        if (!is_null($issuermerchant_id) && !(is_int($issuermerchant_id) || ctype_digit($issuermerchant_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuermerchant_id, true), gettype($issuermerchant_id)), __LINE__);
        }
        $this->issuermerchant_id = $issuermerchant_id;
        return $this;
    }
    /**
     * Get merchanttran_id value
     * @return string|null
     */
    public function getMerchanttran_id()
    {
        return $this->merchanttran_id;
    }
    /**
     * Set merchanttran_id value
     * @param string $merchanttran_id
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setMerchanttran_id($merchanttran_id = null)
    {
        // validation for constraint: string
        if (!is_null($merchanttran_id) && !is_string($merchanttran_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchanttran_id, true), gettype($merchanttran_id)), __LINE__);
        }
        $this->merchanttran_id = $merchanttran_id;
        return $this;
    }
    /**
     * Get terminal_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminal_id()
    {
        return isset($this->terminal_id) ? $this->terminal_id : null;
    }
    /**
     * Set terminal_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminal_id
     * @return \StructType\GetResponseMerchantRequest
     */
    public function setTerminal_id($terminal_id = null)
    {
        // validation for constraint: string
        if (!is_null($terminal_id) && !is_string($terminal_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal_id, true), gettype($terminal_id)), __LINE__);
        }
        if (is_null($terminal_id) || (is_array($terminal_id) && empty($terminal_id))) {
            unset($this->terminal_id);
        } else {
            $this->terminal_id = $terminal_id;
        }
        return $this;
    }
}
