<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseWebshopRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PurchaseWebshopRequest
 * @subpackage Structs
 */
class PurchaseWebshopRequest extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * The CVV2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CVV2;
    /**
     * The CafeteriaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CafeteriaCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The IssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerMerchantId;
    /**
     * The MerchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantTranId;
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalId;
    /**
     * Constructor method for PurchaseWebshopRequest
     * @uses PurchaseWebshopRequest::setAmount()
     * @uses PurchaseWebshopRequest::setCVV2()
     * @uses PurchaseWebshopRequest::setCafeteriaCode()
     * @uses PurchaseWebshopRequest::setCardNumber()
     * @uses PurchaseWebshopRequest::setIssuerMerchantId()
     * @uses PurchaseWebshopRequest::setMerchantTranId()
     * @uses PurchaseWebshopRequest::setTerminalId()
     * @param int $amount
     * @param string $cVV2
     * @param string $cafeteriaCode
     * @param string $cardNumber
     * @param int $issuerMerchantId
     * @param string $merchantTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $cVV2 = null, $cafeteriaCode = null, $cardNumber = null, $issuerMerchantId = null, $merchantTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setCVV2($cVV2)
            ->setCafeteriaCode($cafeteriaCode)
            ->setCardNumber($cardNumber)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setMerchantTranId($merchantTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CVV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCVV2()
    {
        return isset($this->CVV2) ? $this->CVV2 : null;
    }
    /**
     * Set CVV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cVV2
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCVV2($cVV2 = null)
    {
        // validation for constraint: string
        if (!is_null($cVV2) && !is_string($cVV2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV2, true), gettype($cVV2)), __LINE__);
        }
        if (is_null($cVV2) || (is_array($cVV2) && empty($cVV2))) {
            unset($this->CVV2);
        } else {
            $this->CVV2 = $cVV2;
        }
        return $this;
    }
    /**
     * Get CafeteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return isset($this->CafeteriaCode) ? $this->CafeteriaCode : null;
    }
    /**
     * Set CafeteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cafeteriaCode
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        if (is_null($cafeteriaCode) || (is_array($cafeteriaCode) && empty($cafeteriaCode))) {
            unset($this->CafeteriaCode);
        } else {
            $this->CafeteriaCode = $cafeteriaCode;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get IssuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->IssuerMerchantId;
    }
    /**
     * Set IssuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->IssuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get MerchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return isset($this->MerchantTranId) ? $this->MerchantTranId : null;
    }
    /**
     * Set MerchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantTranId
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        if (is_null($merchantTranId) || (is_array($merchantTranId) && empty($merchantTranId))) {
            unset($this->MerchantTranId);
        } else {
            $this->MerchantTranId = $merchantTranId;
        }
        return $this;
    }
    /**
     * Get TerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->TerminalId) ? $this->TerminalId : null;
    }
    /**
     * Set TerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\PurchaseWebshopRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->TerminalId);
        } else {
            $this->TerminalId = $terminalId;
        }
        return $this;
    }
}
