<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionResult
 * @subpackage Structs
 */
class TransactionResult extends AbstractStructBase
{
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The CafeteriaCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CafeteriaCode;
    /**
     * The IssuerReversalTranId
     * @var int
     */
    public $IssuerReversalTranId;
    /**
     * The IssuerTranId
     * @var int
     */
    public $IssuerTranId;
    /**
     * The MerchantTranId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $MerchantTranId;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseMessage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ResponseMessage;
    /**
     * The TranDateTime
     * @var string
     */
    public $TranDateTime;
    /**
     * The TransactionStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TransactionStatus;
    /**
     * Constructor method for TransactionResult
     * @uses TransactionResult::setAuthorizationCode()
     * @uses TransactionResult::setCafeteriaCode()
     * @uses TransactionResult::setIssuerReversalTranId()
     * @uses TransactionResult::setIssuerTranId()
     * @uses TransactionResult::setMerchantTranId()
     * @uses TransactionResult::setResponseCode()
     * @uses TransactionResult::setResponseMessage()
     * @uses TransactionResult::setTranDateTime()
     * @uses TransactionResult::setTransactionStatus()
     * @param string $authorizationCode
     * @param string $cafeteriaCode
     * @param int $issuerReversalTranId
     * @param int $issuerTranId
     * @param string $merchantTranId
     * @param string $responseCode
     * @param string $responseMessage
     * @param string $tranDateTime
     * @param string $transactionStatus
     */
    public function __construct($authorizationCode = null, $cafeteriaCode = null, $issuerReversalTranId = null, $issuerTranId = null, $merchantTranId = null, $responseCode = null, $responseMessage = null, $tranDateTime = null, $transactionStatus = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setCafeteriaCode($cafeteriaCode)
            ->setIssuerReversalTranId($issuerReversalTranId)
            ->setIssuerTranId($issuerTranId)
            ->setMerchantTranId($merchantTranId)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage)
            ->setTranDateTime($tranDateTime)
            ->setTransactionStatus($transactionStatus);
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\TransactionResult
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get CafeteriaCode value
     * @return string|null
     */
    public function getCafeteriaCode()
    {
        return $this->CafeteriaCode;
    }
    /**
     * Set CafeteriaCode value
     * @param string $cafeteriaCode
     * @return \StructType\TransactionResult
     */
    public function setCafeteriaCode($cafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteriaCode) && !is_string($cafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cafeteriaCode, true), gettype($cafeteriaCode)), __LINE__);
        }
        $this->CafeteriaCode = $cafeteriaCode;
        return $this;
    }
    /**
     * Get IssuerReversalTranId value
     * @return int|null
     */
    public function getIssuerReversalTranId()
    {
        return $this->IssuerReversalTranId;
    }
    /**
     * Set IssuerReversalTranId value
     * @param int $issuerReversalTranId
     * @return \StructType\TransactionResult
     */
    public function setIssuerReversalTranId($issuerReversalTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerReversalTranId) && !(is_int($issuerReversalTranId) || ctype_digit($issuerReversalTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerReversalTranId, true), gettype($issuerReversalTranId)), __LINE__);
        }
        $this->IssuerReversalTranId = $issuerReversalTranId;
        return $this;
    }
    /**
     * Get IssuerTranId value
     * @return int|null
     */
    public function getIssuerTranId()
    {
        return $this->IssuerTranId;
    }
    /**
     * Set IssuerTranId value
     * @param int $issuerTranId
     * @return \StructType\TransactionResult
     */
    public function setIssuerTranId($issuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTranId) && !(is_int($issuerTranId) || ctype_digit($issuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTranId, true), gettype($issuerTranId)), __LINE__);
        }
        $this->IssuerTranId = $issuerTranId;
        return $this;
    }
    /**
     * Get MerchantTranId value
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return $this->MerchantTranId;
    }
    /**
     * Set MerchantTranId value
     * @param string $merchantTranId
     * @return \StructType\TransactionResult
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        $this->MerchantTranId = $merchantTranId;
        return $this;
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\TransactionResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ResponseMessage value
     * @return string|null
     */
    public function getResponseMessage()
    {
        return $this->ResponseMessage;
    }
    /**
     * Set ResponseMessage value
     * @param string $responseMessage
     * @return \StructType\TransactionResult
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseMessage, true), gettype($responseMessage)), __LINE__);
        }
        $this->ResponseMessage = $responseMessage;
        return $this;
    }
    /**
     * Get TranDateTime value
     * @return string|null
     */
    public function getTranDateTime()
    {
        return $this->TranDateTime;
    }
    /**
     * Set TranDateTime value
     * @param string $tranDateTime
     * @return \StructType\TransactionResult
     */
    public function setTranDateTime($tranDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($tranDateTime) && !is_string($tranDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDateTime, true), gettype($tranDateTime)), __LINE__);
        }
        $this->TranDateTime = $tranDateTime;
        return $this;
    }
    /**
     * Get TransactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->TransactionStatus;
    }
    /**
     * Set TransactionStatus value
     * @param string $transactionStatus
     * @return \StructType\TransactionResult
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatus) && !is_string($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatus, true), gettype($transactionStatus)), __LINE__);
        }
        $this->TransactionStatus = $transactionStatus;
        return $this;
    }
}
