<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dummy ServiceType
 * @subpackage Services
 */
class Dummy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Dummy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Dummy $parameters
     * @return \StructType\DummyResponse|bool
     */
    public function Dummy(\StructType\Dummy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Dummy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DummyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
