<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionRequestModel.ReversalByMerchantRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionRequestModel.ReversalByMerchantRequest
 * @subpackage Structs
 */
class TransactionRequestModel_ReversalByMerchantRequest extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * The IssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerMerchantId;
    /**
     * The MerchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchantTranId;
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalId;
    /**
     * Constructor method for TransactionRequestModel.ReversalByMerchantRequest
     * @uses TransactionRequestModel_ReversalByMerchantRequest::setAmount()
     * @uses TransactionRequestModel_ReversalByMerchantRequest::setIssuerMerchantId()
     * @uses TransactionRequestModel_ReversalByMerchantRequest::setMerchantTranId()
     * @uses TransactionRequestModel_ReversalByMerchantRequest::setTerminalId()
     * @param int $amount
     * @param int $issuerMerchantId
     * @param string $merchantTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $issuerMerchantId = null, $merchantTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setMerchantTranId($merchantTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\TransactionRequestModel_ReversalByMerchantRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get IssuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->IssuerMerchantId;
    }
    /**
     * Set IssuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\TransactionRequestModel_ReversalByMerchantRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->IssuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get MerchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchantTranId()
    {
        return isset($this->MerchantTranId) ? $this->MerchantTranId : null;
    }
    /**
     * Set MerchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchantTranId
     * @return \StructType\TransactionRequestModel_ReversalByMerchantRequest
     */
    public function setMerchantTranId($merchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTranId) && !is_string($merchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantTranId, true), gettype($merchantTranId)), __LINE__);
        }
        if (is_null($merchantTranId) || (is_array($merchantTranId) && empty($merchantTranId))) {
            unset($this->MerchantTranId);
        } else {
            $this->MerchantTranId = $merchantTranId;
        }
        return $this;
    }
    /**
     * Get TerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->TerminalId) ? $this->TerminalId : null;
    }
    /**
     * Set TerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\TransactionRequestModel_ReversalByMerchantRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->TerminalId);
        } else {
            $this->TerminalId = $terminalId;
        }
        return $this;
    }
}
