<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionRequestModel.ReversalByIssuerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionRequestModel.ReversalByIssuerRequest
 * @subpackage Structs
 */
class TransactionRequestModel_ReversalByIssuerRequest extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Amount;
    /**
     * The IssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerMerchantId;
    /**
     * The IssuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IssuerTranId;
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TerminalId;
    /**
     * Constructor method for TransactionRequestModel.ReversalByIssuerRequest
     * @uses TransactionRequestModel_ReversalByIssuerRequest::setAmount()
     * @uses TransactionRequestModel_ReversalByIssuerRequest::setIssuerMerchantId()
     * @uses TransactionRequestModel_ReversalByIssuerRequest::setIssuerTranId()
     * @uses TransactionRequestModel_ReversalByIssuerRequest::setTerminalId()
     * @param int $amount
     * @param int $issuerMerchantId
     * @param int $issuerTranId
     * @param string $terminalId
     */
    public function __construct($amount = null, $issuerMerchantId = null, $issuerTranId = null, $terminalId = null)
    {
        $this
            ->setAmount($amount)
            ->setIssuerMerchantId($issuerMerchantId)
            ->setIssuerTranId($issuerTranId)
            ->setTerminalId($terminalId);
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\TransactionRequestModel_ReversalByIssuerRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get IssuerMerchantId value
     * @return int|null
     */
    public function getIssuerMerchantId()
    {
        return $this->IssuerMerchantId;
    }
    /**
     * Set IssuerMerchantId value
     * @param int $issuerMerchantId
     * @return \StructType\TransactionRequestModel_ReversalByIssuerRequest
     */
    public function setIssuerMerchantId($issuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerMerchantId) && !(is_int($issuerMerchantId) || ctype_digit($issuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerMerchantId, true), gettype($issuerMerchantId)), __LINE__);
        }
        $this->IssuerMerchantId = $issuerMerchantId;
        return $this;
    }
    /**
     * Get IssuerTranId value
     * @return int|null
     */
    public function getIssuerTranId()
    {
        return $this->IssuerTranId;
    }
    /**
     * Set IssuerTranId value
     * @param int $issuerTranId
     * @return \StructType\TransactionRequestModel_ReversalByIssuerRequest
     */
    public function setIssuerTranId($issuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerTranId) && !(is_int($issuerTranId) || ctype_digit($issuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerTranId, true), gettype($issuerTranId)), __LINE__);
        }
        $this->IssuerTranId = $issuerTranId;
        return $this;
    }
    /**
     * Get TerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerminalId()
    {
        return isset($this->TerminalId) ? $this->TerminalId : null;
    }
    /**
     * Set TerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $terminalId
     * @return \StructType\TransactionRequestModel_ReversalByIssuerRequest
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: string
        if (!is_null($terminalId) && !is_string($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        if (is_null($terminalId) || (is_array($terminalId) && empty($terminalId))) {
            unset($this->TerminalId);
        } else {
            $this->TerminalId = $terminalId;
        }
        return $this;
    }
}
