<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetResponseByIssuerTranId StructType
 * @subpackage Structs
 */
class GetResponseByIssuerTranId extends AbstractStructBase
{
    /**
     * The inIssuerTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inIssuerTranId;
    /**
     * The inIssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inIssuerMerchantId;
    /**
     * The inTerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inTerminalId;
    /**
     * The inAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inAmount;
    /**
     * Constructor method for GetResponseByIssuerTranId
     * @uses GetResponseByIssuerTranId::setInIssuerTranId()
     * @uses GetResponseByIssuerTranId::setInIssuerMerchantId()
     * @uses GetResponseByIssuerTranId::setInTerminalId()
     * @uses GetResponseByIssuerTranId::setInAmount()
     * @param int $inIssuerTranId
     * @param int $inIssuerMerchantId
     * @param string $inTerminalId
     * @param int $inAmount
     */
    public function __construct($inIssuerTranId = null, $inIssuerMerchantId = null, $inTerminalId = null, $inAmount = null)
    {
        $this
            ->setInIssuerTranId($inIssuerTranId)
            ->setInIssuerMerchantId($inIssuerMerchantId)
            ->setInTerminalId($inTerminalId)
            ->setInAmount($inAmount);
    }
    /**
     * Get inIssuerTranId value
     * @return int|null
     */
    public function getInIssuerTranId()
    {
        return $this->inIssuerTranId;
    }
    /**
     * Set inIssuerTranId value
     * @param int $inIssuerTranId
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInIssuerTranId($inIssuerTranId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerTranId) && !(is_int($inIssuerTranId) || ctype_digit($inIssuerTranId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerTranId, true), gettype($inIssuerTranId)), __LINE__);
        }
        $this->inIssuerTranId = $inIssuerTranId;
        return $this;
    }
    /**
     * Get inIssuerMerchantId value
     * @return int|null
     */
    public function getInIssuerMerchantId()
    {
        return $this->inIssuerMerchantId;
    }
    /**
     * Set inIssuerMerchantId value
     * @param int $inIssuerMerchantId
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInIssuerMerchantId($inIssuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerMerchantId) && !(is_int($inIssuerMerchantId) || ctype_digit($inIssuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerMerchantId, true), gettype($inIssuerMerchantId)), __LINE__);
        }
        $this->inIssuerMerchantId = $inIssuerMerchantId;
        return $this;
    }
    /**
     * Get inTerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInTerminalId()
    {
        return isset($this->inTerminalId) ? $this->inTerminalId : null;
    }
    /**
     * Set inTerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inTerminalId
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInTerminalId($inTerminalId = null)
    {
        // validation for constraint: string
        if (!is_null($inTerminalId) && !is_string($inTerminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inTerminalId, true), gettype($inTerminalId)), __LINE__);
        }
        if (is_null($inTerminalId) || (is_array($inTerminalId) && empty($inTerminalId))) {
            unset($this->inTerminalId);
        } else {
            $this->inTerminalId = $inTerminalId;
        }
        return $this;
    }
    /**
     * Get inAmount value
     * @return int|null
     */
    public function getInAmount()
    {
        return $this->inAmount;
    }
    /**
     * Set inAmount value
     * @param int $inAmount
     * @return \StructType\GetResponseByIssuerTranId
     */
    public function setInAmount($inAmount = null)
    {
        // validation for constraint: int
        if (!is_null($inAmount) && !(is_int($inAmount) || ctype_digit($inAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inAmount, true), gettype($inAmount)), __LINE__);
        }
        $this->inAmount = $inAmount;
        return $this;
    }
}
