<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseMobilePOS StructType
 * @subpackage Structs
 */
class PurchaseMobilePOS extends AbstractStructBase
{
    /**
     * The inMerchantTranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inMerchantTranId;
    /**
     * The inIssuerMerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inIssuerMerchantId;
    /**
     * The inTerminalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inTerminalId;
    /**
     * The inCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inCardNumber;
    /**
     * The inCVV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inCVV1;
    /**
     * The inCafeteriaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $inCafeteriaCode;
    /**
     * The inAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inAmount;
    /**
     * Constructor method for PurchaseMobilePOS
     * @uses PurchaseMobilePOS::setInMerchantTranId()
     * @uses PurchaseMobilePOS::setInIssuerMerchantId()
     * @uses PurchaseMobilePOS::setInTerminalId()
     * @uses PurchaseMobilePOS::setInCardNumber()
     * @uses PurchaseMobilePOS::setInCVV1()
     * @uses PurchaseMobilePOS::setInCafeteriaCode()
     * @uses PurchaseMobilePOS::setInAmount()
     * @param string $inMerchantTranId
     * @param int $inIssuerMerchantId
     * @param string $inTerminalId
     * @param string $inCardNumber
     * @param string $inCVV1
     * @param string $inCafeteriaCode
     * @param int $inAmount
     */
    public function __construct($inMerchantTranId = null, $inIssuerMerchantId = null, $inTerminalId = null, $inCardNumber = null, $inCVV1 = null, $inCafeteriaCode = null, $inAmount = null)
    {
        $this
            ->setInMerchantTranId($inMerchantTranId)
            ->setInIssuerMerchantId($inIssuerMerchantId)
            ->setInTerminalId($inTerminalId)
            ->setInCardNumber($inCardNumber)
            ->setInCVV1($inCVV1)
            ->setInCafeteriaCode($inCafeteriaCode)
            ->setInAmount($inAmount);
    }
    /**
     * Get inMerchantTranId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInMerchantTranId()
    {
        return isset($this->inMerchantTranId) ? $this->inMerchantTranId : null;
    }
    /**
     * Set inMerchantTranId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inMerchantTranId
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInMerchantTranId($inMerchantTranId = null)
    {
        // validation for constraint: string
        if (!is_null($inMerchantTranId) && !is_string($inMerchantTranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inMerchantTranId, true), gettype($inMerchantTranId)), __LINE__);
        }
        if (is_null($inMerchantTranId) || (is_array($inMerchantTranId) && empty($inMerchantTranId))) {
            unset($this->inMerchantTranId);
        } else {
            $this->inMerchantTranId = $inMerchantTranId;
        }
        return $this;
    }
    /**
     * Get inIssuerMerchantId value
     * @return int|null
     */
    public function getInIssuerMerchantId()
    {
        return $this->inIssuerMerchantId;
    }
    /**
     * Set inIssuerMerchantId value
     * @param int $inIssuerMerchantId
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInIssuerMerchantId($inIssuerMerchantId = null)
    {
        // validation for constraint: int
        if (!is_null($inIssuerMerchantId) && !(is_int($inIssuerMerchantId) || ctype_digit($inIssuerMerchantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inIssuerMerchantId, true), gettype($inIssuerMerchantId)), __LINE__);
        }
        $this->inIssuerMerchantId = $inIssuerMerchantId;
        return $this;
    }
    /**
     * Get inTerminalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInTerminalId()
    {
        return isset($this->inTerminalId) ? $this->inTerminalId : null;
    }
    /**
     * Set inTerminalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inTerminalId
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInTerminalId($inTerminalId = null)
    {
        // validation for constraint: string
        if (!is_null($inTerminalId) && !is_string($inTerminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inTerminalId, true), gettype($inTerminalId)), __LINE__);
        }
        if (is_null($inTerminalId) || (is_array($inTerminalId) && empty($inTerminalId))) {
            unset($this->inTerminalId);
        } else {
            $this->inTerminalId = $inTerminalId;
        }
        return $this;
    }
    /**
     * Get inCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInCardNumber()
    {
        return isset($this->inCardNumber) ? $this->inCardNumber : null;
    }
    /**
     * Set inCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inCardNumber
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInCardNumber($inCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inCardNumber) && !is_string($inCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inCardNumber, true), gettype($inCardNumber)), __LINE__);
        }
        if (is_null($inCardNumber) || (is_array($inCardNumber) && empty($inCardNumber))) {
            unset($this->inCardNumber);
        } else {
            $this->inCardNumber = $inCardNumber;
        }
        return $this;
    }
    /**
     * Get inCVV1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInCVV1()
    {
        return isset($this->inCVV1) ? $this->inCVV1 : null;
    }
    /**
     * Set inCVV1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inCVV1
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInCVV1($inCVV1 = null)
    {
        // validation for constraint: string
        if (!is_null($inCVV1) && !is_string($inCVV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inCVV1, true), gettype($inCVV1)), __LINE__);
        }
        if (is_null($inCVV1) || (is_array($inCVV1) && empty($inCVV1))) {
            unset($this->inCVV1);
        } else {
            $this->inCVV1 = $inCVV1;
        }
        return $this;
    }
    /**
     * Get inCafeteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInCafeteriaCode()
    {
        return isset($this->inCafeteriaCode) ? $this->inCafeteriaCode : null;
    }
    /**
     * Set inCafeteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inCafeteriaCode
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInCafeteriaCode($inCafeteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($inCafeteriaCode) && !is_string($inCafeteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inCafeteriaCode, true), gettype($inCafeteriaCode)), __LINE__);
        }
        if (is_null($inCafeteriaCode) || (is_array($inCafeteriaCode) && empty($inCafeteriaCode))) {
            unset($this->inCafeteriaCode);
        } else {
            $this->inCafeteriaCode = $inCafeteriaCode;
        }
        return $this;
    }
    /**
     * Get inAmount value
     * @return int|null
     */
    public function getInAmount()
    {
        return $this->inAmount;
    }
    /**
     * Set inAmount value
     * @param int $inAmount
     * @return \StructType\PurchaseMobilePOS
     */
    public function setInAmount($inAmount = null)
    {
        // validation for constraint: int
        if (!is_null($inAmount) && !(is_int($inAmount) || ctype_digit($inAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inAmount, true), gettype($inAmount)), __LINE__);
        }
        $this->inAmount = $inAmount;
        return $this;
    }
}
