<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Purchase ServiceType
 * @subpackage Services
 */
class Purchase extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PurchaseMobilePOS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PurchaseMobilePOS $parameters
     * @return \StructType\PurchaseMobilePOSResponse|bool
     */
    public function PurchaseMobilePOS(\StructType\PurchaseMobilePOS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PurchaseMobilePOS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PurchaseWebshop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PurchaseWebshop $parameters
     * @return \StructType\PurchaseWebshopResponse|bool
     */
    public function PurchaseWebshop(\StructType\PurchaseWebshop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PurchaseWebshop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PurchaseMobilePOSResponse|\StructType\PurchaseWebshopResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
