<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetResponseByMerchantTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResponseByMerchantTranId $parameters
     * @return \StructType\GetResponseByMerchantTranIdResponse|bool
     */
    public function GetResponseByMerchantTranId(\StructType\GetResponseByMerchantTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetResponseByMerchantTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetResponseByIssuerTranId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResponseByIssuerTranId $parameters
     * @return \StructType\GetResponseByIssuerTranIdResponse|bool
     */
    public function GetResponseByIssuerTranId(\StructType\GetResponseByIssuerTranId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetResponseByIssuerTranId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetResponseByIssuerTranIdResponse|\StructType\GetResponseByMerchantTranIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
