<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reversal ServiceType
 * @subpackage Services
 */
class Reversal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReversalMobilePOS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReversalMobilePOS $parameters
     * @return \StructType\ReversalMobilePOSResponse|bool
     */
    public function ReversalMobilePOS(\StructType\ReversalMobilePOS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReversalMobilePOS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReversalWebshop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReversalWebshop $parameters
     * @return \StructType\ReversalWebshopResponse|bool
     */
    public function ReversalWebshop(\StructType\ReversalWebshop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReversalWebshop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReversalMobilePOSResponse|\StructType\ReversalWebshopResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
